/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.io.Serializable;

public class FlagInfo
extends MessageObject
implements Serializable,
Cloneable {
    public Triple location = null;
    public int holderID = 0;
    public int team = -1;
    public boolean reachable = false;
    public String state = "";

    public FlagInfo() {
        super(MessageType.FLAG_INFO);
    }

    public FlagInfo(int ID, String UnrealID, Triple location, boolean reachable, int team, int holderID, String state, boolean visible) {
        super(MessageType.FLAG_INFO, ID, UnrealID, visible);
        this.location = (Triple)location.clone();
        this.reachable = reachable;
        this.team = team;
        this.state = state;
        this.holderID = holderID;
    }

    @Override
    public boolean hasID() {
        return true;
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result + ", location: " + this.location.toString() + ", holder: " + String.valueOf(this.holderID);
        result = result + ", team: " + String.valueOf(this.team) + ", reachable: " + String.valueOf(this.reachable);
        result = result + ", state: " + this.state;
        return result;
    }

    @Override
    public Object clone() {
        return new FlagInfo(this.ID, this.UnrealID, this.location, this.reachable, this.team, this.holderID, this.state, this.visible);
    }

    @Override
    public boolean diff(MessageObject old) {
        FlagInfo oldFlagInfo = (FlagInfo)old;
        boolean changed = false;
        if (oldFlagInfo.location.equals(this.location)) {
            this.location = null;
        } else {
            oldFlagInfo.location = this.location;
            changed = true;
        }
        if (oldFlagInfo.reachable != this.reachable) {
            oldFlagInfo.reachable = this.reachable;
            changed = true;
        }
        if (oldFlagInfo.holderID != this.holderID) {
            oldFlagInfo.holderID = this.holderID;
            changed = true;
        }
        if (oldFlagInfo.state.equals(this.state)) {
            this.state = null;
        } else {
            oldFlagInfo.state = this.state;
            changed = true;
        }
        return changed;
    }

    @Override
    public void update(MessageObject newMsgObj) {
        FlagInfo newFlagInfo = (FlagInfo)newMsgObj;
        if (newMsgObj.UnrealID != null) {
            this.UnrealID = newFlagInfo.UnrealID;
        }
        if (newFlagInfo.location != null) {
            this.location = newFlagInfo.location;
        }
        if (newFlagInfo.state != null) {
            this.state = newFlagInfo.state;
        }
        this.reachable = newFlagInfo.reachable;
        this.holderID = newFlagInfo.holderID;
        this.team = newFlagInfo.team;
    }
}

