/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.utils.HashCode;

public class DominationPoint
extends MessageObject {
    public int controller = 0;
    public Triple location = null;
    private boolean hashComputed = false;
    private int hashCode = 0;
    public boolean reachable = false;

    public DominationPoint(int ID, String UnrealID, Triple location, boolean reachable, boolean visible, int controller, int hashCode) {
        super(MessageType.NAV_POINT, ID, UnrealID, visible);
        this.location = (Triple)location.clone();
        this.controller = controller;
        this.reachable = reachable;
        this.hashCode = hashCode;
    }

    public DominationPoint() {
        super(MessageType.DOM_POINT);
    }

    @Override
    public boolean hasID() {
        return true;
    }

    private int getHashCode() {
        HashCode hc = new HashCode();
        if (this.location != null) {
            hc.add(this.location.x);
            hc.add(this.location.y);
            hc.add(this.location.z);
        } else {
            System.out.println("DomPoint doesn't have a location - error in hash code!!!");
            System.out.println(this.UnrealID);
            System.out.println(this.toString());
        }
        hc.add(this.ID);
        return hc.getHash();
    }

    public int hashCode() {
        if (!this.hashComputed) {
            this.hashCode = this.getHashCode();
        }
        return this.hashCode;
    }

    @Override
    public Object clone() {
        if (!this.hashComputed) {
            this.hashCode = this.getHashCode();
        }
        return new DominationPoint(this.ID, this.UnrealID, this.location, this.reachable, this.visible, this.controller, this.hashCode);
    }

    public Triple getLocation() {
        return this.location;
    }

    public void setLocation(Triple newLocation) {
        this.location.setTriple(newLocation);
    }

    public boolean isReachable() {
        return this.reachable;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean diff(MessageObject old) {
        boolean changed = false;
        DominationPoint oldDom = (DominationPoint)old;
        if (this.reachable != oldDom.reachable) {
            oldDom.reachable = this.reachable;
            changed = true;
        }
        if (this.visible != oldDom.visible) {
            oldDom.visible = this.visible;
            changed = true;
        }
        if (this.controller != oldDom.controller) {
            oldDom.controller = this.controller;
            changed = true;
        }
        return changed;
    }

    @Override
    public void update(MessageObject newMsgObj) {
        DominationPoint newDom = (DominationPoint)newMsgObj;
        this.visible = newDom.visible;
        this.reachable = newDom.reachable;
        this.controller = newDom.controller;
        if (newDom.location != null) {
            this.location = (Triple)newDom.location.clone();
        }
    }

    @Override
    public String toString() {
        String content = ", Location: " + (this.location == null ? "null" : this.location.toString());
        content = content + ", Controller: " + String.valueOf(this.controller) + ", Reachability: " + this.reachable + ", Visibility: " + this.visible + ", Neighbours: ";
        return super.toString() + content;
    }
}

