/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.SynchronousMessages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class HistoryBatch
implements Cloneable {
    private HashMap<MessageType, HashMap<Integer, MessageObject>> messages = new HashMap();
    private HistoryBatch next;
    public static int counterForAnonymousID = -1;
    public Logger batchLogger;

    public HistoryBatch(Logger logger) {
        for (MessageType type : MessageType.values()) {
            this.messages.put(type, new HashMap());
        }
        this.batchLogger = logger;
        this.next = null;
    }

    public HistoryBatch getNext() {
        return this.next;
    }

    public void setNext(HistoryBatch next) {
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageObject getMessage(MessageType type, int ID) {
        HashMap<MessageType, HashMap<Integer, MessageObject>> hashMap = this.messages;
        synchronized (hashMap) {
            HashMap<Integer, MessageObject> msgs = this.messages.get((Object)type);
            if (msgs == null) {
                return null;
            }
            return msgs.get(ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMessage(MessageObject newMsg) {
        MessageType type = newMsg.getType();
        HashMap<MessageType, HashMap<Integer, MessageObject>> hashMap = this.messages;
        synchronized (hashMap) {
            if (SynchronousMessages.synchroMessages.contains((Object)newMsg.getType())) {
                if (!newMsg.visible && this.messages.get((Object)type).containsKey(newMsg.getID())) {
                    if (newMsg.type == MessageType.NAV_POINT && !((NavPoint)newMsg).reachable) {
                        this.messages.get((Object)type).remove(newMsg.getID());
                    } else {
                        this.messages.get((Object)type).remove(newMsg.getID());
                    }
                } else {
                    this.messages.get((Object)type).put(newMsg.getID(), (MessageObject)newMsg.clone());
                }
            } else {
                if (counterForAnonymousID == Integer.MIN_VALUE) {
                    counterForAnonymousID = -1;
                }
                if (newMsg.getID() == 0) {
                    this.messages.get((Object)type).put(counterForAnonymousID--, newMsg);
                } else {
                    this.messages.get((Object)type).put(newMsg.getID(), newMsg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HistoryBatch copyVisibleObjects() {
        HistoryBatch clon = new HistoryBatch(this.batchLogger);
        HashMap<MessageType, HashMap<Integer, MessageObject>> hashMap = this.messages;
        synchronized (hashMap) {
            for (MessageType type : MessageType.values()) {
                if (!SynchronousMessages.synchroMessages.contains((Object)type) || this.messages.get((Object)type).isEmpty()) continue;
                clon.messages.put(type, new HashMap());
                Set<Integer> keys = this.messages.get((Object)type).keySet();
                Iterator<Integer> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    MessageObject temp = this.messages.get((Object)type).get(iterator.next());
                    clon.messages.get((Object)type).put(temp.getID(), temp);
                }
            }
        }
        return clon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasObjectOfType(int type) {
        HashMap<MessageType, HashMap<Integer, MessageObject>> hashMap = this.messages;
        synchronized (hashMap) {
            if (this.messages.get(type).isEmpty()) {
                return false;
            }
            Set<Integer> keys = this.messages.get(type).keySet();
            Iterator<Integer> iterator = keys.iterator();
            return iterator.hasNext();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageObject getFirstObjectOfType(MessageType type) {
        HashMap<MessageType, HashMap<Integer, MessageObject>> hashMap = this.messages;
        synchronized (hashMap) {
            if (this.messages.get((Object)type).isEmpty()) {
                return null;
            }
            Set<Integer> keys = this.messages.get((Object)type).keySet();
            Iterator<Integer> iterator = keys.iterator();
            if (iterator.hasNext()) {
                return this.messages.get((Object)type).get(iterator.next());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap<Integer, MessageObject> getAllObjectsOfType(MessageType type) {
        HashMap<MessageType, HashMap<Integer, MessageObject>> hashMap = this.messages;
        synchronized (hashMap) {
            return this.messages.get((Object)type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HashMap<MessageType, HashMap<Integer, MessageObject>> hashMap = this.messages;
        synchronized (hashMap) {
            return this.messages.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MessageType type, int id) {
        HashMap<MessageType, HashMap<Integer, MessageObject>> hashMap = this.messages;
        synchronized (hashMap) {
            this.messages.get((Object)type).remove(id);
        }
    }
}

