/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.astar.AStar;
import cz.cuni.astar.AStarResult;
import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.GameMapAStarGoal;
import cz.cuni.pogamut.Client.GameMapAStarMap;
import cz.cuni.pogamut.Client.GameMapSettings;
import cz.cuni.pogamut.Client.ItemDistance;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Mover;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Path;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.communication.CommunicationState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.logging.Logger;

public class GameMap
implements RcvMsgListener {
    private Logger platformLog;
    private AgentBody body = null;
    private AgentMemory memory = null;
    private ArrayList<Path> collectedPaths = new ArrayList();
    private boolean isUpOnTheLift = false;
    private Item nextItem = null;
    private ArrayList<NavPoint> pathToRunAlong = null;
    private boolean pathRequested = false;
    private int nextItemIndex = 0;
    private int nextNavPointIndex = 0;
    private int walking;
    protected ArrayList<NavPoint> pathToItem = null;
    protected boolean pathInitialized = false;
    private int counterPathID = 10000;
    private int pathID = 0;
    private boolean pathRequestSent = false;
    int tempCounter = 0;

    public GameMap(Logger logger) {
        this.platformLog = logger;
    }

    public GameMap(Logger logger, AgentBody body) {
        this.platformLog = logger;
        this.body = body;
        this.body.addTypedRcvMsgListener(this, MessageType.PATH);
        this.body.addRcvMsgListener(this, EnumSet.of(MessageType.SPAWN));
    }

    public GameMap(Logger logger, AgentBody body, AgentMemory memory) {
        this.platformLog = logger;
        this.body = body;
        this.body.addTypedRcvMsgListener(this, MessageType.PATH);
        this.memory = memory;
        this.body.addRcvMsgListener(this, EnumSet.of(MessageType.SPAWN));
    }

    public ArrayList<Item> nearestHealth(int strength, int numberOfHealths) {
        ArrayList<Health> candidates = this.memory.getKnownHealths();
        ArrayList<Health> processedCandidates = new ArrayList<Health>();
        for (Health health : candidates) {
            if (health.strength < strength) continue;
            processedCandidates.add(health);
        }
        ArrayList<ItemDistance> res = new ArrayList<ItemDistance>();
        AStarResult aStarResult = null;
        for (Health health : processedCandidates) {
            aStarResult = this.getPathAStar(health.navPoint);
            if (!aStarResult.success) continue;
            res.add(new ItemDistance(health, aStarResult.getDistanceToGoal()));
        }
        Collections.sort(res);
        ArrayList<Item> result = new ArrayList<Item>();
        for (int i = 0; i < res.size() && i < numberOfHealths; ++i) {
            result.add(((ItemDistance)res.get((int)i)).item);
        }
        return result;
    }

    public ArrayList<Item> nearestItems(MessageType type, int numberOfItems) {
        ArrayList<Item> candidates = this.memory.getKnownItemsOfType(type);
        ArrayList<ItemDistance> res = new ArrayList<ItemDistance>();
        AStarResult aStarResult = null;
        for (Item item : candidates) {
            aStarResult = this.getPathAStar(item.navPoint);
            if (!aStarResult.success) continue;
            res.add(new ItemDistance(item, aStarResult.getDistanceToGoal()));
        }
        Collections.sort(res);
        ArrayList<Item> result = new ArrayList<Item>();
        for (int i = 0; i < res.size() && i < numberOfItems; ++i) {
            result.add(((ItemDistance)res.get((int)i)).item);
        }
        return result;
    }

    public NavPoint nearestNavPoint(Triple from) {
        double distance;
        ArrayList<MessageObject> candidates = this.body.knownObjects.getObjectsOfType(MessageType.NAV_POINT);
        double currentDistance = distance = Double.MAX_VALUE;
        NavPoint closest = null;
        for (MessageObject candidate : candidates) {
            if (((NavPoint)candidate).location == null || !(distance > (currentDistance = Triple.distanceInPlane(((NavPoint)candidate).location, from)))) continue;
            distance = currentDistance;
            closest = (NavPoint)candidate;
        }
        return closest;
    }

    public NavPoint nearestNavPoint(Triple from, int minDistance) {
        double distance;
        ArrayList<MessageObject> candidates = this.body.knownObjects.getObjectsOfType(MessageType.NAV_POINT);
        double currentDistance = distance = Double.MAX_VALUE;
        NavPoint closest = null;
        NavPoint temp = null;
        for (MessageObject candidate : candidates) {
            temp = (NavPoint)candidate;
            if (temp.location == null || !(distance > (currentDistance = Triple.distanceInPlane(temp.location, from))) || !((double)minDistance < currentDistance)) continue;
            distance = currentDistance;
            closest = temp;
        }
        return closest;
    }

    public void sendGetPathToNavPoint(NavPoint toWhat) {
        this.body.getPath(toWhat.getLocation(), toWhat.ID);
    }

    public void sendGetPathToLocation(int ID, Triple toWhat) {
        this.body.getPath(toWhat, ID);
    }

    public Path getPathOfID(int ID) {
        for (int i = 0; i < this.collectedPaths.size(); ++i) {
            if (Integer.valueOf(this.collectedPaths.get((int)i).pongID) != ID) continue;
            return this.collectedPaths.get(i);
        }
        return null;
    }

    public AStarResult getPathAStar(NavPoint toWhat, int maxNumOfIterations) {
        if (toWhat == null) {
            return null;
        }
        GameMapAStarGoal goal = new GameMapAStarGoal(toWhat);
        GameMapAStarMap map = new GameMapAStarMap();
        NavPoint start = new NavPoint();
        start.location = this.memory.getAgentLocation();
        start.neighbours = new ArrayList();
        ArrayList<NavPoint> nvs = this.memory.seeAllNavPoints();
        for (int i = 0; i < nvs.size(); ++i) {
            NeighNav nn = new NeighNav();
            nn.neighbour = nvs.get(i);
            start.neighbours.add(nn);
        }
        assert (goal != null);
        assert (map != null);
        assert (start != null);
        return AStar.aStar(goal, map, start, maxNumOfIterations);
    }

    public ArrayList<NavPoint> getNavPointsAStar(AStarResult result) {
        if (result.success) {
            ArrayList path = result.getPath();
            ArrayList<NavPoint> navPoints = new ArrayList<NavPoint>();
            for (Object pathNode : path) {
                if (pathNode instanceof NavPoint) {
                    navPoints.add((NavPoint)pathNode);
                    continue;
                }
                if (pathNode instanceof NeighNav) {
                    navPoints.add(((NeighNav)pathNode).neighbour);
                    continue;
                }
                this.platformLog.severe("Wrong object in the A* path (" + pathNode.toString() + ").");
            }
            return navPoints;
        }
        return null;
    }

    public AStarResult getPathAStar(NavPoint toWhat) {
        AStarResult result = this.getPathAStar(toWhat, -1);
        if (result.success) {
            this.platformLog.finest("PATH A*: " + this.specialPrint(this.getNavPointsAStar(result)));
        } else {
            this.platformLog.info("PATH A*: failed unable to get path A Star");
        }
        return result;
    }

    @Override
    public void receiveMessage(RcvMsgEvent e) {
        if (e.getCommunicationState() != CommunicationState.BOT_RUNNING) {
            return;
        }
        switch (e.getMessage().type) {
            case PATH: {
                this.collectedPaths.add(0, (Path)e.getMessage());
                if (this.collectedPaths.size() <= GameMapSettings.maxCollectedPaths) break;
                this.collectedPaths.remove(GameMapSettings.maxCollectedPaths);
                break;
            }
            case SPAWN: {
                this.restartMap();
                break;
            }
            default: {
                this.platformLog.warning("Unexpected message!!!");
            }
        }
    }

    public void initializeGetPath() {
        this.pathRequestSent = false;
    }

    public ArrayList<NavPoint> getPathToLocation(Triple location) {
        if (this.pathRequestSent) {
            if (this.getPathOfID(this.pathID) == null) {
                return null;
            }
            this.pathRequestSent = false;
            return this.getPathOfID((int)this.pathID).nodes;
        }
        ++this.counterPathID;
        if (this.counterPathID == Integer.MAX_VALUE) {
            this.counterPathID = 10000;
        }
        this.pathID = this.counterPathID;
        this.sendGetPathToLocation(this.pathID, location);
        this.pathRequestSent = true;
        return null;
    }

    public void initializeRunAlongPath(Path path) {
        this.platformLog.info("PATH initialized by path");
        this.nextNavPointIndex = 0;
        this.isUpOnTheLift = false;
        this.walking = 0;
        this.pathToRunAlong = path.nodes;
    }

    public void initializeRunAlongPath(ArrayList<NavPoint> path) {
        this.platformLog.fine("PATH initialized by array list");
        this.nextNavPointIndex = 0;
        this.isUpOnTheLift = false;
        this.walking = 0;
        this.pathToRunAlong = path;
    }

    public boolean stuckCheck() {
        boolean stucked = this.antiStuckCheck(this.pathToRunAlong.get((int)this.nextNavPointIndex).location);
        boolean attempts = false;
        ++this.walking;
        if (this.walking > GameMapSettings.maxWalkingAttempts) {
            attempts = true;
        }
        if (attempts && stucked) {
            attempts = false;
            this.platformLog.fine("REPLAN because bot reached max ATTEMPTS and was STUCKED");
            return false;
        }
        return true;
    }

    public boolean runAlongPath() {
        if (this.pathToRunAlong == null) {
            this.platformLog.warning("procedure called when the variables were not properly initialized!");
            return false;
        }
        if (this.nextNavPointIndex >= this.pathToRunAlong.size()) {
            this.platformLog.fine("runAlongPath - PATH END : " + this.pathToRunAlong);
            return false;
        }
        NavPoint nav1 = this.pathToRunAlong.get(this.nextNavPointIndex);
        if (Triple.distanceInSpace(this.memory.getAgentLocation(), nav1.location) < (double)GameMapSettings.switchingDistance) {
            this.platformLog.info("Switching to another navigation point. Last point: " + nav1.UnrealID);
            this.walking = 0;
            ++this.nextNavPointIndex;
        }
        if (nav1 == null || nav1.UnrealID == null) {
            ++this.nextNavPointIndex;
            return true;
        }
        if (nav1.UnrealID.indexOf("LiftCenter") != -1 && Triple.distanceInPlane(this.memory.getAgentLocation(), nav1.location) < (double)GameMapSettings.switchingDistance) {
            this.platformLog.info("Switching to another navigation point. Last point: " + nav1.UnrealID);
            this.walking = 0;
            ++this.nextNavPointIndex;
        }
        if (this.nextNavPointIndex < this.pathToRunAlong.size() - 1) {
            NavPoint nav2 = this.pathToRunAlong.get(this.nextNavPointIndex + 1);
            try {
                if (nav1.UnrealID.indexOf("LiftCenter") != -1 && nav2.UnrealID.indexOf("LiftExit") != -1 && this.memory.getAgentLocation().z - nav1.location.z < 50.0) {
                    if (!this.memory.getSeeAnyMover()) {
                        return false;
                    }
                    Mover mov = this.memory.getSeeMover();
                    if (mov.location.z - this.memory.getAgentLocation().z > (double)GameMapSettings.levelForEnteringLift) {
                        this.platformLog.fine("Waiting for MOVER to come DOWN");
                        ++this.walking;
                        if (this.walking > GameMapSettings.maxWalkingAttempts) {
                            this.walking = 0;
                            return false;
                        }
                        return true;
                    }
                    this.platformLog.fine("ENTERING the Mover");
                    this.body.runToNavPoint(nav1);
                    this.isUpOnTheLift = true;
                    return this.stuckCheck();
                }
                if (this.isUpOnTheLift && nav1.UnrealID.indexOf("LiftExit") != 1) {
                    if (!this.memory.getSeeAnyMover()) {
                        return false;
                    }
                    if (nav1.location.z - this.memory.getAgentLocation().z < (double)GameMapSettings.levelForLeavingLift) {
                        this.platformLog.fine("LEAVING MOVER!");
                        this.isUpOnTheLift = false;
                        this.body.runToNavPoint(nav1);
                        return this.stuckCheck();
                    }
                    this.body.turnToLocation(nav1.location);
                    ++this.walking;
                    if (this.walking > GameMapSettings.maxWalkingAttempts) {
                        this.walking = 0;
                        return false;
                    }
                    this.platformLog.fine("GOING UP " + (nav1.location.z - this.memory.getAgentLocation().z));
                    return true;
                }
                this.body.moveAlongNavPoints(1.0, nav1, this.pathToRunAlong.get(this.nextNavPointIndex + 1));
                return this.stuckCheck();
            }
            catch (NullPointerException e) {
                this.platformLog.warning("Null pointer exception in run along path " + e.getMessage());
            }
        } else if (this.nextNavPointIndex < this.pathToRunAlong.size()) {
            this.body.runToNavPoint(this.pathToRunAlong.get(this.nextNavPointIndex));
            return this.stuckCheck();
        }
        return false;
    }

    protected void obtainPathToNextItem() {
        if (this.pathRequested && this.getPathOfID(this.nextItem.ID) != null) {
            this.pathToRunAlong = this.getPathOfID((int)this.nextItem.ID).nodes;
        } else {
            if (this.nextItem.location == null) {
                this.nextItem = null;
                return;
            }
            this.body.getPathToLocation(this.nextItem.ID, this.nextItem.location);
            this.pathRequested = true;
        }
    }

    public void runAroundItemsInTheMap(ArrayList<Item> itemsToRunAround, boolean AStar2) {
        if (this.nextItem == null) {
            this.platformLog.fine("TOTAL RESTART OF RUN AROUND ITEMS IN MAP");
            Collections.shuffle(itemsToRunAround);
            this.nextItem = itemsToRunAround.get(0);
            this.nextItemIndex = 0;
            this.pathRequested = false;
            this.pathToRunAlong = null;
            this.nextNavPointIndex = 0;
            this.walking = 0;
            this.isUpOnTheLift = false;
            return;
        }
        if (this.nextItem == null) {
            return;
        }
        if (this.pathToRunAlong == null) {
            if (AStar2) {
                this.pathToRunAlong = this.getNavPointsAStar(this.getPathAStar(this.nextItem.navPoint));
                this.platformLog.fine("Path Request A*");
                if (this.pathToRunAlong == null) {
                    this.platformLog.info("PROBLEM WITH A* - failed to find a way - use GB");
                    this.obtainPathToNextItem();
                }
            } else {
                this.platformLog.fine("Path Request For Gamebots");
                this.obtainPathToNextItem();
            }
            return;
        }
        if (this.pathToRunAlong.size() < 1) {
            this.platformLog.info("too short path to run along to next - restart");
            this.nextItem = null;
            return;
        }
        if (this.runAlongPath()) {
            this.platformLog.fine("running along path with no problems");
            return;
        }
        this.platformLog.severe("runAlongPath FAILED or FINISHED. PATH: \n" + this.specialPrint(this.pathToRunAlong));
        if (++this.nextItemIndex < itemsToRunAround.size()) {
            this.nextItem = itemsToRunAround.get(this.nextItemIndex);
            this.platformLog.info("SWITCHING - running to another item in the list. \nNext item is: " + this.nextItem.cls);
            this.pathRequested = false;
            this.pathToRunAlong = null;
            this.nextNavPointIndex = 0;
            this.isUpOnTheLift = false;
            this.walking = 0;
        } else {
            this.nextItem = null;
        }
    }

    protected String specialPrint(ArrayList path) {
        String result = "";
        if (path == null) {
            return result;
        }
        int i = 0;
        for (Object o : path) {
            MessageObject mo = (MessageObject)o;
            result = result + mo.UnrealID + ";\t";
            if (++i <= 2) continue;
            result = result + "\n";
            i = 0;
        }
        return result;
    }

    public void restartPathToRunAlong() {
        this.pathToRunAlong = null;
        this.pathRequested = false;
        this.nextNavPointIndex = 0;
        this.walking = 0;
    }

    public void restartMap() {
        this.restartPathToRunAlong();
        this.nextItem = null;
        this.collectedPaths = new ArrayList();
        this.nextItemIndex = 0;
        this.isUpOnTheLift = false;
    }

    public boolean antiStuckCheck(Triple goal) {
        Triple velocity = this.memory.getAgentVelocity();
        Triple location = this.memory.getAgentLocation();
        Triple nextPosition = Triple.add(velocity, location);
        double distanceDifference = Triple.vectorSize(Triple.subtract(goal, location));
        if ((distanceDifference -= Triple.vectorSize(Triple.subtract(goal, nextPosition))) < (double)GameMapSettings.distanceDifference) {
            this.platformLog.finest("DIFFERENCE " + this.tempCounter);
            ++this.tempCounter;
            return true;
        }
        if (Triple.vectorSize(velocity) < (double)GameMapSettings.minimalVelocity) {
            this.platformLog.finest("VELO " + Triple.vectorSize(velocity));
            return true;
        }
        if (goal.z - location.z > (double)GameMapSettings.heightLevel) {
            this.platformLog.finest("HIGH HIGH HIGH HIGH ");
            return true;
        }
        return false;
    }

    public boolean safeRunToLocation(Triple location, boolean[] runRestart) {
        if (runRestart[0]) {
            this.pathToItem = null;
            this.initializeGetPath();
            this.pathToItem = this.getPathToLocation(location);
            runRestart[0] = false;
            this.pathInitialized = false;
            return true;
        }
        if (this.pathToItem == null) {
            this.pathToItem = this.getPathToLocation(location);
            return true;
        }
        if (!this.pathInitialized) {
            this.initializeRunAlongPath(this.pathToItem);
            this.pathInitialized = true;
            return true;
        }
        if (!this.runAlongPath()) {
            this.platformLog.info("path to item failed or finished. ");
            runRestart[0] = true;
            return false;
        }
        return true;
    }
}

