/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.exceptions.ConnectException;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class AgentLauncher {
    private Agent agent = null;
    private URI ut = null;
    private boolean localParser = true;
    private boolean launched = false;

    public AgentLauncher(Agent agent, URI ut, boolean localParser) {
        this.agent = agent;
        this.ut = ut;
        this.localParser = localParser;
    }

    public Agent getAgent() {
        return this.agent;
    }

    private void alterLogToScreen(Logger log) {
        log.getParent().removeHandler(log.getParent().getHandlers()[0]);
        log.getParent().addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.println(record.getSourceClassName() + " " + record.getSourceMethodName() + ": " + record.getMessage());
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        });
    }

    public void setLogToScreen() {
        this.alterLogToScreen(this.agent.getLogger());
    }

    public void setLogPlatformToScreen() {
        this.alterLogToScreen(this.agent.getPlatformLog());
    }

    public Thread launch() {
        return this.launch(null);
    }

    public Thread launch(String name) {
        if (this.launched) {
            return null;
        }
        this.launched = true;
        if (this.localParser) {
            try {
                this.agent.bindLocalParser(this.ut);
            }
            catch (IOException e1) {
                System.out.println(e1.getMessage());
                e1.printStackTrace();
                return null;
            }
            catch (ConnectException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        } else {
            try {
                this.agent.bindRemoteParser(this.ut);
            }
            catch (ConnectException e) {
                e.printStackTrace();
                return null;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.agent.startAgent(name, false);
    }
}

