class MapVisConnection extends GBClientClass;

//Parent server
var MapVisServer Parent;

var config float UpdateTime;

//Accepted connection to a socket
event Accepted()
{
	log("MapVis Connection established.");

	if(bDebug)
		log("Accepted MapVisConnection");

	if (bNewProtocol)
	{
		SendLine("HELLO MAP SERVER");
		gotoState('monitoring','Waiting');
	}
	else
	{
		SendGameInfo();
		gotoState('monitoring','running');
	}


}

//Connection closed at remote end
event Closed()
{
	Destroy();
}

event Destroyed()
{
	SendLine("FIN");
}

//Handles commands for MapVisServer
function ProcessAction(string cmdType)
{

	if(bDebug)
		log("comandType:"@cmdType);

	switch(cmdType)
	{
		case "READY":
			ExportNavPoints();
			gotoState('monitoring','Running');
		break;
		case "START":
			gotoState('monitoring','Running');
		break;
		case "STOP":
			gotoState('monitoring','Waiting');
		break;
		case "QUIT":
			Destroy();
		break;
		case "PING":
			SendLine("PONG");
		break;
		case "GETNAVS":
			ExportNavPoints();
		break;
		case "GETPLRS":
			ExportPlayers();
		break;
		case "GETINVS":
			ExportInventory();
		break;

	}
}



//Default State for receiving commands
auto state monitoring
{
Begin:
Waiting:
	sleep(5.0);
	goto 'Waiting';
Running:
	ExportPlayers();
	/*
	SendLine("BEG" $ib$as$ "Time" $ib$ Level.TimeSeconds $ae);
	GetPlayers();
	SendLine("END" $ib$as$ "Time" $ib$ Level.TimeSeconds $ae);
	  */
	sleep(UpdateTime);
	goto 'Running';
}

defaultproperties
{
	UpdateTime=0.2500
	bNewProtocol=true
    as="{"
    ae="}"
    ib=" "
}
