/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.sposhBot.java;

import cz.cuni.pogamut.Client.ScriptedAgent;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.exceptions.ScriptedAgentException;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.utils.Config;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.script.ScriptException;

public class SPoshBot
extends ScriptedAgent {
    protected String pathToJythonJar = Config.getJythonJarPath() == null ? ".\\scripting\\jython.jar" : Config.fixPythonPath(Config.getJythonJarPath());
    protected String pathToSPOSH = Config.getPythonModulePath() == null ? ".\\scripting\\python" : Config.fixPythonPath(Config.getPythonModulePath());
    protected String sposhPlanFile = null;
    protected JavaBehaviour behaviour = null;

    public SPoshBot(JavaBehaviour behaviour, String sposhPlanFileName, String pathToSPOSH, String pathToJythonJar) throws ScriptedAgentException {
        if (pathToSPOSH != null) {
            this.pathToSPOSH = pathToSPOSH;
        }
        if (pathToJythonJar != null) {
            this.pathToJythonJar = pathToJythonJar;
        }
        this.behaviour = behaviour;
        this.sposhPlanFile = sposhPlanFileName;
        this.init();
    }

    public SPoshBot(JavaBehaviour behaviour, String sposhPlanFileName) throws ScriptedAgentException {
        this.behaviour = behaviour;
        this.sposhPlanFile = sposhPlanFileName;
        this.init();
    }

    protected void init() throws ScriptedAgentException {
        if (this.pathToSPOSH == null) {
            throw new IllegalArgumentException("Path to SPOSH module is null.");
        }
        if (this.pathToJythonJar == null) {
            throw new IllegalArgumentException("Path to JythonJar is null.");
        }
        if (this.behaviour == null) {
            throw new IllegalArgumentException("Behaviour is null, forbidden.");
        }
        if (this.sposhPlanFile == null) {
            throw new IllegalArgumentException("Path to '.lap' file with SPOSH plan is null.");
        }
        if (!new File(this.pathToSPOSH).exists()) {
            throw new IllegalArgumentException("SPOSH module not found. Normaly it should reside under $POGAMUT_PLATFORM/scripting/python/");
        }
        if (!new File(this.pathToJythonJar).exists()) {
            throw new IllegalArgumentException("Directory with jython.jar not found. Normaly it should points to $POGAMUT_PLATFORM/scriptEngines/");
        }
        this.bindEngineByName("python");
        try {
            this.engine.eval("import sys");
            this.engine.eval("sys.path.append('" + this.pathToSPOSH + "')");
            this.engine.eval("sys.path.append('" + this.pathToJythonJar + "')");
            this.setAttribute("userDir", System.getProperty("user.dir"));
            this.setAttribute("behaviour", this.behaviour);
        }
        catch (ScriptException e) {
            throw new ScriptedAgentException("Can't set Python path to SPOSH or Jython.jar, can't initialize.", e);
        }
    }

    @Override
    protected void doLogic() {
        if (!this.memory.hasSelf()) {
            return;
        }
        try {
            this.invocableEngine.invokeMethod(this.engine.getContext().getAttribute("sposhAgent"), "followDrive", null);
        }
        catch (ScriptException e) {
            this.platformLog.severe("Script error -> " + e.getMessage());
            this.stopAgentSoft();
        }
        catch (NoSuchMethodException e) {
            this.platformLog.severe("Script error -> " + e.getMessage());
            this.stopAgentSoft();
        }
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
        try {
            this.setAttribute("platformLog", this.platformLog);
            this.engine.eval("from sposh.agent import Agent");
            this.engine.eval("sposhAgent = Agent([behaviour], '" + this.sposhPlanFile + "', platformLog)");
        }
        catch (ScriptException e) {
            this.platformLog.severe("Can't instantiate SPOSH agent -> " + e.getMessage());
            System.exit(1);
        }
    }

    @Override
    protected void prePrepareAgent() throws PogamutException {
    }

    @Override
    protected void shutdownAgent() throws PogamutException {
    }

    public static void main(String[] Args) {
        String userdir = System.getProperty("user.dir");
        SPoshBot bot = null;
        try {
            bot = new SPoshBot(new JavaBehaviour("simple"), userdir + "\\src\\cz\\cuni\\sposhBot\\java\\exampleSPoshBotPlan.lap");
        }
        catch (ScriptedAgentException e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        URI uri = null;
        try {
            uri = new URI("ut://artemis.ms.mff.cuni.cz:3000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("URI creation failed, terminating.");
            System.exit(0);
        }
        bot.log.getParent().removeHandler(bot.log.getParent().getHandlers()[0]);
        bot.log.getParent().addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.println(record.getSourceClassName() + " " + record.getSourceMethodName() + ": " + record.getMessage());
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        });
        try {
            bot.bindLocalParser(uri);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
            System.exit(1);
        }
        catch (ConnectException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        bot.startAgent();
    }
}

