// Unreal Script :
// Author:

//We've got this class here to allow specators to go through walls
class GBxPlayer extends xPlayer;

//var NameMarker pickup;
var ScriptedTexture Tex;
var GBhud GBHUD;
var GBHUDInteraction GBHUDInter;

replication
{
    // Functions server can call.
    reliable if( Role==ROLE_Authority )
		Test, DrawLine, DrawTraceLine;
}



/*
simulated event PostBeginPlay()
{
	super.PostBeginPlay();
	BotHUD = spawn(class'BotAPI.GBHud', self);

}
*/


function NotifyTakeHit(pawn InstigatedBy, vector HitLocation, int Damage, class<DamageType> damageType, vector Momentum)
{
	super.NotifyTakeHit(InstigatedBy, HitLocation, Damage, damageType, Momentum);

	if(InstigatedBy != none && InstigatedBy.Controller != none && InstigatedBy.Controller.isA('RemoteBot')) {

	    RemoteBot(InstigatedBy.Controller).RemoteNotifyHit(self, Damage, DamageType);

	}
}

/*
function UpdateHUDBotPositions()
{
	local int i,j;
	local Controller C;

	if (GBHUD == none)
		return;

	i = 0;
	for (C = Level.ControllerList; C != none; C=C.NextController)
	{
		if (C.IsA('RemoteBot'))
		{
			GBHUD.RemBotId[i] = C $ C.PlayerReplicationInfo.PlayerId;
			if (C.Pawn != none)
				GBHUD.RemBotLoc[i] = C.Pawn.Location;
			else
				GBHUD.RemBotLoc[i] = vect(0,0,0);
			i++;
			if (i > 19) //We are limited by HUD resolution
				break;
		}
	}
	if (i < 20) //We erase possible rem bots from previous batch
	{
		if (GBHUD.RemBotId[i] != "")
		{
			for (j = i; j < 20; j++)
			{
				GBHUD.RemBotId[i] = "";
				GBHUD.RemBotLoc[i] = vect(0,0,0);
			}
		}
	}

}*/
function Test()
{
	DrawStayingDebugLine(Pawn.Location,Pawn.Location + 500 * vector(Pawn.Rotation),255,0,0);
	log("In GBxPLayer test() this location: "$Pawn.Location);
}

simulated function DrawTraceLine(vector LineStart,vector LineEnd,bool LineHit)
{
	if (LineHit)
	{
		DrawDebugLine(LineStart,LineEnd,255,0,0);
		log("Draw Line hit");
	}
	else
	{
		DrawDebugLine(LineStart,LineEnd,0,255,0);
		log("Draw Line miss");
	}

}

simulated function DrawLine(vector LineStart,vector LineEnd)
{

	DrawStayingDebugLine(LineStart,LineEnd,255,0,0);
	log("Drawing Line");

}

//We need to change this fc a little bit so our bots can receive msgs from players
function ServerSay( string Msg )
{
	local controller C;

	// center print admin messages which start with #
	if (PlayerReplicationInfo.bAdmin && left(Msg,1) == "#" )
	{
		Msg = right(Msg,len(Msg)-1);
		for( C=Level.ControllerList; C!=None; C=C.nextController )
		{
			if( C.IsA('PlayerController') )
			{
				PlayerController(C).ClearProgressMessages();
				PlayerController(C).SetProgressTime(6);
				PlayerController(C).SetProgressMessage(0, Msg, class'Canvas'.Static.MakeColor(255,255,255));
			}
			if( C.IsA('RemoteBot') )
			{
				RemoteBot(C).RemoteNotifyClientMessage( PlayerReplicationInfo.PlayerName, Msg );
			}

		}
		return;
	}

	for( C=Level.ControllerList; C!=None; C=C.nextController )
	{
		if( C.IsA('RemoteBot') )
		{
			RemoteBot(C).RemoteNotifyClientMessage( PlayerReplicationInfo.PlayerName, Msg );
		}

	}

	Level.Game.Broadcast(self, Msg, 'Say');
}

simulated event Destroyed()
{
	super.Destroyed();
	if (GBHUD != none)
	{
		log("Detroying hud");
		GBHUD.Destroy();
	}

}

function ServerTeamSay( string Msg )
{
	local Controller C;

	LastActiveTime = Level.TimeSeconds;

	if( !GameReplicationInfo.bTeamGame )
	{
		Say( Msg );
		return;
	}

    for( C=Level.ControllerList; C!=None; C=C.nextController )
	{
		if( C.IsA('RemoteBot') && (C.PlayerReplicationInfo.Team.TeamIndex == PlayerReplicationInfo.Team.TeamIndex) )
		{
			RemoteBot(C).RemoteNotifyTeamMessage( PlayerReplicationInfo.PlayerName, Msg );
		}

	}

    Level.Game.BroadcastTeam( self, Level.Game.ParseMessageString( Level.Game.BaseMutator , self, Msg ) , 'TeamSay');
}

state Spectating
{
    ignores SwitchWeapon, RestartLevel, ClientRestart, Suicide,
     ThrowWeapon, NotifyPhysicsVolumeChange, NotifyHeadVolumeChange;

    exec function Fire( optional float F )
    {
    	if ( bFrozen )
	{
		if ( (TimerRate <= 0.0) || (TimerRate > 1.0) )
			bFrozen = false;
		return;
	}

        ServerViewNextPlayer();
    }

    // Return to spectator's own camera.
    exec function AltFire( optional float F )
    {
        bBehindView = false;
        ServerViewSelf();
    }

    function Timer()
    {
    	bFrozen = false;
    }

    function BeginState()
    {
        if ( Pawn != None )
        {
            SetLocation(Pawn.Location);
            UnPossess();
        }
	log("We are in spect. state, setting collisions off");
        bCollideWorld = false;

	CameraDist = Default.CameraDist;
    }

    function EndState()
    {
        PlayerReplicationInfo.bIsSpectator = false;
        bCollideWorld = false;
    }
}

auto state PlayerWaiting
{
ignores SeePlayer, HearNoise, NotifyBump, TakeDamage, PhysicsVolumeChange, NextWeapon, PrevWeapon, SwitchToBestWeapon;

    exec function Jump( optional float F )
    {
    }

    exec function Suicide()
    {
    }

    function ServerRestartPlayer()
    {
        if ( Level.TimeSeconds < WaitDelay )
            return;
        if ( Level.NetMode == NM_Client )
            return;
        if ( Level.Game.bWaitingToStartMatch )
            PlayerReplicationInfo.bReadyToPlay = true;
        else
            Level.Game.RestartPlayer(self);
        }

    exec function Fire(optional float F)
    {
        LoadPlayers();
        if ( !bForcePrecache && (Level.TimeSeconds > 0.2) )
			ServerReStartPlayer();
    }

    exec function AltFire(optional float F)
    {
        Fire(F);
    }

    function EndState()
    {
        if ( Pawn != None )
            Pawn.SetMesh();
        if ( PlayerReplicationInfo != None )
			PlayerReplicationInfo.SetWaitingPlayer(false);
        bCollideWorld = false;
    }

    function BeginState()
    {
		CameraDist = Default.CameraDist;
        if ( PlayerReplicationInfo != None )
            PlayerReplicationInfo.SetWaitingPlayer(true);
	log("We are in playerwaiting, setting collisions off");
        bCollideWorld = false;


    }
}

defaultproperties
{

}








