class BotCTFGame extends CTFGameCopy;

#exec OBJ LOAD FILE=TeamSymbols.utx

function string GetGameStatus(optional RemoteBot theBot)
{
	local string ib, as, ae;
	local string outStr;
	local CTFFlag MyFlag, Flag;

	ib = theBotServer.ib;
	as = theBotServer.as;
	ae = theBotServer.ae;

	outStr = super.GetGameStatus();

	if ( thebot != none )
	{
		foreach AllActors (class'CTFFlag', Flag)
		{
			if( Flag.Team.TeamIndex == theBot.PlayerReplicationInfo.Team.TeamIndex)
			{
               MyFlag = Flag;
               break;
			}
		}

		if ( theBot.PlayerReplicationInfo.HasFlag != None )
			outStr = ( outStr $ib$as$ "HaveFlag" $ib$ thebot.PlayerReplicationInfo.HasFlag $ae );
		if ( (MyFlag != None) && !MyFlag.bHome )
			outStr = ( outStr $ib$as$ "EnemyHasFlag" $ib$ "1" $ae );
	}

	return outStr;
}


defaultproperties
{
	DefaultEnemyRosterClass="xGame.xTeamRoster"
	MapListType="XInterface.MapListCaptureTheFlag"
	GoalScore=7
	DeathMessageClass=XGame.xDeathMessage
	ScreenShotName="UT2004Thumbnails.CTFShots"
	DecoTextName="XGame.CTFGame"
	Acronym="CTF"
	NetWait=2
	CountDown=0
	bAllowControlServer=true
	PlayerControllerClassName="BotAPI.GBxPlayer"
	HUDType="xInterface.HudCCaptureTheFlag"
	GameName="Remote Bot CTF Game"
	GameClass="BotCTFGame"
	MapPrefix="CTF"
}

