/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.exampleBots;

import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.Client.BaseBot;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

public class PreyBot
extends BaseBot {
    protected boolean jumped = false;
    protected ArrayList<Item> healths = null;

    public PreyBot() {
        this.log.setLevel(Level.INFO);
        this.platformLog.setLevel(Level.INFO);
    }

    @Override
    protected void postPrepareAgent() {
        this.healths = new ArrayList();
        for (Health item : this.memory.getKnownHealths()) {
            this.healths.add(item);
        }
        Collections.shuffle(this.healths);
    }

    @Override
    protected void doLogic() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.severe("Agent was ruthlessly interrupted during the sleep!");
            e.printStackTrace();
        }
        if (!this.memory.hasSelf()) {
            return;
        }
        if (this.memory.isColliding()) {
            this.stateWalking();
            return;
        }
        this.stateGoAroundItems();
    }

    protected void stateWalking() {
        this.log.log(Level.INFO, "Decision is: WALKING");
        if (this.memory.isColliding()) {
            if (!this.jumped) {
                this.body.jump();
                this.jumped = true;
            } else {
                this.body.stop();
                this.jumped = false;
            }
        }
        if (this.memory.isFalling()) {
            this.body.sendGlobalMessage("I am flying like a bird:D!");
            this.log.info("I'm flying like an angel to the sky ... it's so high ... oh, I am high! :-)");
        }
        if (this.memory.isBumpingToAnotherActor()) {
            this.body.stop();
        }
    }

    protected void stateGoAroundItems() {
        this.log.log(Level.INFO, "Decision is: GO AROUND ITEMS");
        this.gameMap.runAroundItemsInTheMap(this.healths, true);
    }

    public static void main(String[] Args) {
        PreyBot bot = new PreyBot();
        boolean localParser = true;
        URI uri = null;
        try {
            uri = new URI("ut://artemis.ms.mff.cuni.cz:3000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("URI creation failed, terminating.");
            System.exit(0);
        }
        AgentLauncher launcher = new AgentLauncher(bot, uri, localParser);
        launcher.setLogToScreen();
        launcher.launch();
    }
}

