/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Parser;

import cz.cuni.pogamut.Parser.RemoteParserServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RemoteParser {
    public static final int DEFAULT_PORT = 4000;
    public final URI gbUri;
    public final int serverPort;
    private boolean serverSocketInitialized = false;
    private RemoteParserServer server = null;
    private boolean serverStarted = false;
    private Thread serverThread = null;
    public static Logger log = Logger.getAnonymousLogger();

    public RemoteParser(String url) throws URISyntaxException {
        this.serverPort = 4000;
        if (!url.contains(":")) {
            url = url + ":3000";
        }
        this.gbUri = new URI("ut://" + url);
    }

    public RemoteParser(String url, int port) throws URISyntaxException {
        this.serverPort = port;
        if (!url.contains(":")) {
            url = url + ":3000";
        }
        this.gbUri = new URI("ut://" + url);
    }

    public boolean checkGameBot() {
        String host = this.gbUri.getHost();
        int port = this.gbUri.getPort();
        Socket socket = null;
        BufferedReader input = null;
        try {
            log.info("Testing GameBot presence at " + host + ":" + port);
            socket = new Socket(host, port);
        }
        catch (IOException e) {
            log.severe("Can't connect to GameBot (" + host + ":" + port + "), check the address and UT2004-Gamebots server.");
            return false;
        }
        log.info("Connected to GameBot.");
        try {
            input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (IOException e) {
            log.severe("Can't get input stream of the socket.");
            try {
                socket.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            return false;
        }
        log.info("Awaiting HELLO BOT message from GameBot.");
        try {
            if (!input.readLine().equals("HELLO BOT")) {
                log.severe("No HELLO BOT received - assuming it's not GameBot.");
                socket.close();
                return false;
            }
        }
        catch (IOException e) {
            log.severe("Can't read from GameBot. Check UT2004-Gamebot server.");
            try {
                socket.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            return false;
        }
        log.info("HELLO BOT message received, GameBot confirmed, closing testing connection.");
        try {
            socket.close();
        }
        catch (IOException e) {
            log.warning("Can't close testing connection.");
        }
        return true;
    }

    public boolean initServer() {
        if (this.serverSocketInitialized) {
            log.severe("Can't initialize server socket - one has been already initialized.");
            return false;
        }
        log.info("Initializing server socket at " + this.serverPort + ".");
        try {
            this.server = new RemoteParserServer(this.serverPort, this.gbUri, log);
        }
        catch (Exception e) {
            log.severe("Can't open server socket at " + this.serverPort + ".");
            return false;
        }
        this.serverSocketInitialized = true;
        log.info("Socket for Clients (agents) opened at " + this.serverPort + ".");
        return true;
    }

    public boolean startServer() {
        if (!this.serverSocketInitialized) {
            log.severe("ServerSocket wasn't initiCan't initialize server socket - one has been already initialized.");
            return false;
        }
        if (this.serverStarted) {
            log.severe("RemoteParser already started. Can't start thread.");
            return false;
        }
        this.serverThread = new Thread((Runnable)this.server, "Remote parser " + this.gbUri.toString());
        this.serverThread.start();
        this.serverStarted = true;
        return true;
    }

    public static void printHelp() {
        System.out.println("===================================");
        System.out.println("RemoteParser for Pogamut 2 Platform");
        System.out.println("===================================");
        System.out.println("");
        System.out.println("RemoteParser is meant to save the network traffic between GameBot and Client.");
        System.out.println("It's standing between GameBot and the Client (agent) - can be seen as the mediator.");
        System.out.println("");
        System.out.println("It's doing two things:");
        System.out.println("1) parse text messages from GameBot");
        System.out.println("    1.a) receive and parse text message from GameBot");
        System.out.println("    1.b) creates equivalent Java objects (class MessageObject)");
        System.out.println("    1.c) applies delta compression");
        System.out.println("    1.d) sends delta message to the Client (agent)");
        System.out.println("2) sending messages from Client to the GameBot");
        System.out.println("");
        System.out.println("To start the remote parser you need to specify the url of the GameBots.");
        System.out.println("You may optionaly specify the port where the parser is accepting the incoming connections from Clients.");
        System.out.println("");
        System.out.println("Default port for Clients (agents) is 4000.");
        System.out.println("");
        System.out.println("------");
        System.out.println("Usage:");
        System.out.println("------");
        System.out.println("");
        System.out.println("java -cp path_to_dir_with_cz_dir cz.cuni.pogamut.Parser.RemoteParser address_of_gamebots [port_where_to_listen]");
        System.out.println("");
        System.out.println("Example:");
        System.out.println("");
        System.out.println("java -cp . cz.cuni.pogamut.Parser.RemoteParser abc.university.com");
        System.out.println("");
        System.out.println("This will start the parser assuming that at computer abc.university.com is running UT2004 with GameBots and will listen on the port 4000 awaiting Clients (agents).");
        System.out.println("");
        System.out.println("java -cp . cz.cuni.pogamut.Parser.RemoteParser abc.university.com 4321");
        System.out.println("");
        System.out.println("This will start the parser assuming that at computer abc.university.com is running UT2004 with GameBots and will listen on the port 4321 awaiting Clients (agents).");
        System.out.println("");
    }

    public static void initLogger() {
        log.getParent().removeHandler(log.getParent().getHandlers()[0]);
        log.getParent().addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.println(record.getSourceClassName() + " " + record.getSourceMethodName() + ": " + record.getMessage());
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        });
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            RemoteParser.printHelp();
            System.exit(1);
        }
        if (args[0].charAt(0) == '-' || args[0].charAt(0) == '/' || args[0].equals("h") || args[0].equals("help")) {
            RemoteParser.printHelp();
            System.exit(1);
        }
        RemoteParser.initLogger();
        log.info("RemoteParser initializing.");
        RemoteParser remoteParser = null;
        switch (args.length) {
            case 1: {
                try {
                    remoteParser = new RemoteParser(args[0]);
                }
                catch (URISyntaxException e) {
                    log.severe("Can't create RemoteParser instance, wrong URL.");
                    System.exit(1);
                }
                break;
            }
            case 2: {
                try {
                    remoteParser = new RemoteParser(args[0], Integer.valueOf(args[1]));
                    break;
                }
                catch (URISyntaxException e) {
                    log.severe("Can't create RemoteParser instance, wrong URL.");
                    System.exit(1);
                }
            }
        }
        log.info("RemoteParser instance created.");
        if (!remoteParser.checkGameBot()) {
            System.exit(1);
        }
        if (!remoteParser.initServer()) {
            System.exit(1);
        }
        if (!remoteParser.startServer()) {
            System.exit(1);
        }
    }
}

