/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentIterationEndEvent;
import cz.cuni.pogamut.Client.AgentIterationEndListener;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.GameMap;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.Command;
import cz.cuni.pogamut.MessageObjects.CommandTypes;
import cz.cuni.pogamut.MessageObjects.GameInfo;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.Parser.GameBotConnection;
import cz.cuni.pogamut.Parser.Parser;
import cz.cuni.pogamut.Parser.ParserConnection;
import cz.cuni.pogamut.Parser.UnrealIDMap;
import cz.cuni.pogamut.communication.CommunicationState;
import cz.cuni.pogamut.communication.Mediator;
import cz.cuni.pogamut.communication.RemoteParserForMediator;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.introspection.Introspectable;
import cz.cuni.pogamut.introspection.IntrospectableProxy;
import cz.cuni.pogamut.introspection.PogProp;
import cz.cuni.pogamut.introspection.java.JavaReflectionProxy;
import cz.cuni.pogamut.server.ParserType;
import cz.cuni.utils.ExceptionToString;
import cz.cuni.utils.Flag;
import cz.cuni.utils.FlagListener;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Agent
implements Runnable,
RcvMsgListener,
Introspectable {
    public static int GARBAGE_COLLECTOR_FREQUENCY = 50;
    @PogProp
    public double logicFrequency = 8.0;
    private static int botNum = 0;
    private Flag<Boolean> threadLogicAlive = new Flag<Boolean>(false);
    private boolean exceptionOccured = false;
    private boolean logicShouldRun = true;
    private Thread threadLogic = null;
    private String defaultBotName = "PogamutBot";
    private CountDownLatch logicStartLatch = null;
    private CountDownLatch logicPauseLatch = null;
    private boolean logicIsPaused = false;
    protected ArrayList<AgentIterationEndListener> iterationEndListeners = new ArrayList();
    protected AgentBody body = null;
    protected AgentMemory memory = null;
    protected GameMap gameMap = null;
    protected boolean fileLogging = false;
    protected Logger log;
    protected FileHandler logHandler = null;
    protected Logger platformLog;
    protected FileHandler platformLogHandler = null;
    protected static final int FILE_LOG_FLUSH_INTERVAL = 10;
    protected int fileLogFlushCounter = 0;
    protected Logger parserLogger = null;
    protected Random random = new Random();
    protected ParserType bindedParserType = null;
    protected GameBotConnection gameBotConnection = null;
    protected Logger rawGBLog = Logger.getAnonymousLogger();

    protected void initMemory() {
        this.memory = new AgentMemory(this.platformLog, this.body, this);
    }

    protected void initBody() {
        this.body = new AgentBody(this.platformLog);
        this.body.addRcvMsgListener(this);
        this.body.exceptionOccured.addListener(new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue, int listenerParam) {
                if (changedValue.booleanValue()) {
                    Agent.this.platformLog.severe("Exception occured, stopping agent.");
                    Agent.this.exceptionOccured = true;
                }
            }
        });
    }

    protected void initGameMap() {
        this.gameMap = new GameMap(this.platformLog, this.body, this.memory);
    }

    public AgentBody getBody() {
        return this.body;
    }

    public AgentMemory getMemory() {
        return this.memory;
    }

    public Thread getLogicThread() {
        return this.threadLogic;
    }

    public CommunicationState getCommunicationState() {
        return this.body.communicationState.getFlag();
    }

    public Mediator getMediator() {
        return this.body.mediator;
    }

    public String getName() {
        String name = this.memory.getAgentName();
        if (name != null) {
            return name;
        }
        return this.defaultBotName;
    }

    protected void initLogging() {
        this.log = Logger.getAnonymousLogger();
        this.platformLog = Logger.getAnonymousLogger();
        this.log.setLevel(Level.ALL);
        this.platformLog.setLevel(Level.ALL);
        this.platformLog.config("Start of logging");
    }

    protected void initFileLogging(String botName) {
        String logFilePath = botName + " UserLog " + System.currentTimeMillis() + ".log";
        String platformLogFilePath = botName + " PlatformLog " + System.currentTimeMillis() + ".log";
        try {
            this.platformLogHandler = new FileHandler(platformLogFilePath);
            this.logHandler = new FileHandler(logFilePath);
            this.log.addHandler(this.logHandler);
            this.platformLog.addHandler(this.platformLogHandler);
        }
        catch (IOException e) {
            System.out.println("Unable to log to file!!!" + e);
        }
    }

    public Agent() {
        this.initLogging();
        this.initBody();
        this.initMemory();
        this.initGameMap();
        this.body.addTypedRcvMsgListener(this, MessageType.MAP_FINISHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIterationEndListener(AgentIterationEndListener listener) {
        ArrayList<AgentIterationEndListener> arrayList = this.iterationEndListeners;
        synchronized (arrayList) {
            ArrayList clone = (ArrayList)this.iterationEndListeners.clone();
            clone.add(listener);
            this.iterationEndListeners = clone;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIterationEndListener(AgentIterationEndListener listener) {
        ArrayList<AgentIterationEndListener> arrayList = this.iterationEndListeners;
        synchronized (arrayList) {
            ArrayList clone = (ArrayList)this.iterationEndListeners.clone();
            clone.remove(listener);
            this.iterationEndListeners = clone;
            return true;
        }
    }

    public void setLogicStartLatch(CountDownLatch latch) {
        this.logicStartLatch = latch;
    }

    public void bindLocalParser(URI gameBots) throws IOException, ConnectException {
        GameBotConnection gb;
        if (this.body.mediator != null) {
            this.platformLog.severe("AgentBody's mediator already initialized - assuming second bindLocalParser() was called - forbidden!");
            return;
        }
        if (this.threadLogicAlive.getFlag().booleanValue()) {
            this.platformLog.severe("Logic thread flag is TRUE - logic should be already running, assuming second startAgentLocalParser() was called - forbidden! Agent's not started.");
        }
        this.platformLog.info("Binding local parser.");
        this.platformLog.info("Connecting to GameBots at " + gameBots.toString());
        this.gameBotConnection = gb = new GameBotConnection(gameBots.getHost(), this.rawGBLog);
        gb.connect();
        UnrealIDMap idMap = new UnrealIDMap();
        this.platformLog.info("Creating local parser.");
        Parser parser = new Parser(gb, idMap, this.platformLog);
        this.platformLog.info("Creating communication mediator.");
        Mediator mediator = new Mediator(this.body, parser, parser, this.platformLog);
        this.body.bindMediator(mediator);
        this.bindedParserType = ParserType.LOCAL;
    }

    public void bindRemoteParser(URI parser) throws ConnectException, UnknownHostException {
        if (this.body.mediator != null) {
            this.platformLog.severe("AgentBody's mediator already initialized - assuming second bindRemoteParser() was called - forbidden!");
            return;
        }
        if (this.threadLogicAlive.getFlag().booleanValue()) {
            this.platformLog.severe("Logic thread flag is TRUE - logic should be already running, assuming second bindRemoteParser() was called - forbidden!");
            return;
        }
        this.platformLog.info("Binding remote parser.");
        this.platformLog.info("Connecting to RemotePaser at " + parser.toString());
        ParserConnection remoteParser = new ParserConnection(parser.getHost());
        remoteParser.connect();
        this.platformLog.info("Creating remote parser interface.");
        RemoteParserForMediator parserInterface = new RemoteParserForMediator(remoteParser);
        this.platformLog.info("Creating communication mediator.");
        Mediator mediator = new Mediator(this.body, parserInterface, parserInterface, this.platformLog);
        this.body.bindMediator(mediator);
        this.bindedParserType = ParserType.REMOTE;
    }

    public Logger getRawDataLog() {
        return this.rawGBLog;
    }

    public Thread startAgent(String botName, boolean logToFile) {
        if (this.body.mediator == null) {
            this.platformLog.severe("Can't start agent. Parser wasn't bind to the body.");
            return null;
        }
        if (botName == null) {
            botName = this.body.isNameBinded() ? this.body.getBindedName() : "PogamutBot";
        }
        this.defaultBotName = botName = botName + "_" + String.valueOf(botNum++);
        this.body.bindName(botName);
        if (logToFile) {
            this.fileLogging = logToFile;
            this.initFileLogging(botName);
        }
        this.platformLog.info("Starting agent.");
        this.platformLog.info("Calling prePrepareAgent().");
        try {
            this.prePrepareAgent();
        }
        catch (PogamutException e1) {
            this.platformLog.severe(ExceptionToString.process("Exception occured in prePrepareAgent(), agent can't be started.", e1));
            try {
                this.body.mediator.sendMessageToGB(new Command("QUIT", CommandTypes.QUIT));
            }
            catch (CantWriteException e2) {
                // empty catch block
            }
            this.body.mediator.stopMediator();
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
            return null;
        }
        this.platformLog.info("Starting the mediator.");
        this.body.mediator.startMediator();
        this.body.mediator.pauseClientParserThread();
        try {
            this.body.navpointsItemsReceivedLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.platformLog.info("Handshake with gamebots successfull, running postPrepareAgent().");
        try {
            this.postPrepareAgent();
        }
        catch (PogamutException e) {
            this.platformLog.severe(ExceptionToString.process("Exception occured in postPrepareAgent(), can't start the agent.", e));
            try {
                this.body.mediator.sendMessageToGB(new Command("QUIT", CommandTypes.QUIT));
            }
            catch (CantWriteException e1) {
                // empty catch block
            }
            this.body.mediator.stopMediator();
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
            return null;
        }
        this.body.fireLogicLatch.countDown();
        this.platformLog.info("postPrepareAgent() finished, starting logic thread.");
        this.threadLogic = new Thread((Runnable)this, "Bot: " + botName + " - logic");
        this.threadLogicAlive.setFlag(true);
        this.threadLogic.start();
        return this.threadLogic;
    }

    public Thread startAgent() {
        if (this.body.isNameBinded()) {
            return this.startAgent(null, false);
        }
        return this.startAgent("PogamutBot", false);
    }

    public Logger getLogger() {
        return this.log;
    }

    public Logger getPlatformLog() {
        return this.platformLog;
    }

    public boolean logicReady() {
        if (this.memory.memoryRestarted) {
            this.memory.switchMemories();
            return true;
        }
        return this.memory.hasSelf();
    }

    @Override
    public void run() {
        if (this.threadLogic == null) {
            this.platformLog.severe("Agent run() called but threadLogic == null, aborting.");
            return;
        }
        this.platformLog.info("Logic thread started.");
        boolean garbageCollector = false;
        try {
            if (this.logicStartLatch != null) {
                this.platformLog.info("Awaiting on the logic latch.");
                this.logicStartLatch.await();
                this.platformLog.info("Latch raised, agent logic started.");
            }
            if (this.memory.getGameInfo().botsPaused) {
                this.pauseLogic();
            }
            while (this.isRunning()) {
                if (this.logicIsPaused) {
                    this.platformLog.finest("Switching communication state to PAUSED.");
                    this.body.getCommunicationStateFlag().setFlag(CommunicationState.PAUSED);
                    this.logicPauseLatch.await();
                    this.platformLog.finest("Switching communication state to BOT_RUNNING.");
                    this.body.getCommunicationStateFlag().setFlag(CommunicationState.BOT_RUNNING);
                }
                int milisecToSleep = 1;
                if (this.logicFrequency < 1000.0 && this.logicFrequency > 0.0) {
                    milisecToSleep = (int)(1000.0 / this.logicFrequency);
                }
                if (this.logicFrequency > 20.0) {
                    this.platformLog.info("Logic frequency is too high. Recommended frequency is between 5 to 20Hz");
                }
                if (this.logicFrequency < 5.0) {
                    this.platformLog.info("Logic frequency is too low. Recommended frequency is between 5 to 20Hz");
                }
                try {
                    Thread.sleep(milisecToSleep);
                }
                catch (InterruptedException e) {
                    this.log.severe(ExceptionToString.process("Agent was ruthlessly interrupted during the sleep!", e));
                }
                if (this.logicReady()) {
                    this.doLogic();
                } else {
                    try {
                        Thread.sleep(120L);
                    }
                    catch (InterruptedException e) {
                        this.log.severe(ExceptionToString.process("Agent was ruthlessly interrupted during the sleep!", e));
                    }
                    this.platformLog.info("Wainting for the SELF message.");
                }
                if (this.fileLogging) {
                    if (10 < ++this.fileLogFlushCounter) {
                        this.logHandler.flush();
                        this.platformLogHandler.flush();
                        this.fileLogFlushCounter = 0;
                    }
                }
                for (AgentIterationEndListener listener : this.iterationEndListeners) {
                    listener.iterationEnds(new AgentIterationEndEvent(this));
                }
            }
        }
        catch (Exception e) {
            this.platformLog.severe(ExceptionToString.process("Exception occured - shutting down the agent.", e));
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
        }
        if (this.body.mediator.isCommunicationAlive()) {
            this.platformLog.info("Logic stopped, closing agent connection to UT.");
            this.body.mediator.stopMediator();
        } else if (this.body.communicationState.getFlag() != CommunicationState.MAP_FINISHED) {
            this.platformLog.severe("Connection lost, stopping logic, probably communication exception");
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
        } else {
            this.platformLog.severe("Communication stopped.");
        }
        this.body.mediator.resumeClientParserThread();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        if (!CommunicationState.getEndStates().contains((Object)this.body.communicationState.getFlag())) {
            this.platformLog.finest("Switching communication state to TERMINATED.");
            this.body.communicationState.setFlag(CommunicationState.TERMINATED);
        }
        this.platformLog.info("Calling shutdownAgent().");
        try {
            this.shutdownAgent();
        }
        catch (PogamutException e) {
            this.platformLog.severe(ExceptionToString.process("Exception in shutdownAgent() occured.", e));
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
        }
        this.platformLog.info("shutdownAgent() finished, logic thread stopped.");
        if (this.logHandler != null) {
            this.logHandler.close();
        }
        if (this.platformLogHandler != null) {
            this.platformLogHandler.close();
        }
        this.threadLogicAlive.setFlag(false);
    }

    protected void prePrepareAgent() throws PogamutException {
    }

    protected void postPrepareAgent() throws PogamutException {
    }

    protected void shutdownAgent() throws PogamutException {
    }

    protected void doLogic() throws PogamutException {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.severe(ExceptionToString.process("Agent interrupted during sleep in doLogic", e));
        }
    }

    public boolean isRunning() {
        return this.body.mediator.isCommunicationAlive() && this.logicShouldRun && !this.exceptionOccured;
    }

    public void disconnect() {
        this.stopAgentSoft();
    }

    public void stopAgentSoft() {
        this.platformLog.info("stopAgentSoft() called, stopping logic thread (soft).");
        this.logicShouldRun = false;
        if (this.logicIsPaused) {
            this.resumeLogic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(RcvMsgEvent e) {
        switch (e.getMessage().getType()) {
            case MAP_FINISHED: {
                this.platformLog.severe("Map finished.");
                this.platformLog.finest("Switching communication state to MAP_FINIESHED");
                this.body.communicationState.setFlag(CommunicationState.MAP_FINISHED);
                this.stopAgentSoft();
                break;
            }
            case GAME_PAUSED: {
                GameInfo info1;
                GameInfo gameInfo = info1 = this.memory.getGameInfo();
                synchronized (gameInfo) {
                    info1.gamePaused = true;
                    this.pauseLogic();
                    break;
                }
            }
            case GAME_RESUMED: {
                GameInfo info2;
                GameInfo gameInfo = info2 = this.memory.getGameInfo();
                synchronized (gameInfo) {
                    info2.gamePaused = false;
                    this.resumeLogic();
                    break;
                }
            }
        }
    }

    @Override
    public IntrospectableProxy getIntrospectableProxy() {
        return new JavaReflectionProxy(this);
    }

    public synchronized void pauseLogic() {
        if (this.logicIsPaused) {
            return;
        }
        this.platformLog.config("pauseLogic() called, raising flag");
        this.logicPauseLatch = new CountDownLatch(1);
        this.logicIsPaused = true;
    }

    public synchronized void resumeLogic() {
        if (!this.logicIsPaused) {
            return;
        }
        this.platformLog.config("pauseLogic() called, dropping flag");
        this.logicIsPaused = false;
        this.logicPauseLatch.countDown();
        this.platformLog.finest("Switching communication state to BOT_RUNNING.");
        this.body.getCommunicationStateFlag().setFlag(CommunicationState.BOT_RUNNING);
    }

    public ParserType getBindedParserType() {
        return this.bindedParserType;
    }

    public void sendMessageToGB(String str) throws CantWriteException {
        this.gameBotConnection.send(str);
    }
}

