/*

Gamebots UT Copyright (c) 2002, Andrew N. Marshal, Gal Kaminka
Gamebots UT 2003/2004 port Copyright (c) 2005
       Joe Manojlovich, Tim Garwood, Jessica Bayliss
Gamebots Pogamut derivation Copyright (c) 2007, Michal Bida
	- derived mainly from 2002 Marshal, Kaminka version

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/


//=============================================================================
// RemoteBot.
// Basedon Bot class
//=============================================================================
class RemoteBot extends Bot
	config(GameBots2004);


var config bool bDebug;

//maybe link to bot's periphreal vision? UT bots need much less of an arc though
//like Pawn's PeriphrealVision, this value should be the cosine of the limits
//of visual field. (i.e. 0.707 = 45 degrees to each side, or a 90* arc.)
var config float remoteVisionLimit;

//The socket to the agent
var BotConnection myConnection;


//The three remote vars compliment the my vars right below. The only one
//that ever needs to be duplicated is RemoteEnemy and myTarget
//just need RemoteDestination || myDestination and RFocus || myFocus

//Who the remote bot is trying to shoot at. Used by the aiming code.
var Actor RemoteEnemy;
//Thing the remote bot is trying to move to.
var Actor RemoteDestination;
//Thing the remote bot is looking at.
var Actor myFocus;

//The spot the bot is shooting at
var FocusActorClass myTarget;

//If false, we will update myTarget location according our current focal point
var bool bTargetLocationLocked;

//The spot the bot is moving to
var vector myDestination;
//The spot the bot is looking at
var vector myFocalPoint;

//This is an indicator that we are in StartUp:MoveContinuous state. We need this, so turn
//command work properly when the bot is moving continuous!
var bool movingContinuous;

// time that last sent a WAL message
var float lastWallHitTime;

// time that last sent a BMP message
var float lastBumpTime;

var name BoneName;


var config float DeltaTime;

//var actor HitWall;

//var vector HitNormal;

//var vector HitLocation;

//Used for smooth movement, see StartUp state
var vector pendingDestination;

//If true bot will respawn automatically when killed
var config bool bAutoSpawn;

//When true auto raytracing producing sync. ATR messsages will be on
var config bool bAutoTrace;

//If true we will draw trace lines (results of AutoTrace() functionsin BotConnection)
//in the game
var config bool bDrawTraceLines;

//If we should spawn an actor at the point the bot has set as focal point
var config bool bShowFocalPoint;

//If we should provide aim correct based on bot Skill also when shooting at Location
var config bool bPerfectLocationAim;

//If we should include FadeOut attribute into message text or not. for debug.
var config bool bIncludeFadeOutInMsg;

//maximum number we can multiply BaseSpeed of the bot
var config float MaxSpeed;

//Used for changing the bot appearance. see GBxPawn.Setup() function
var config string DesiredSkin;

//TODO: Probably not used anymore - delete
var bool bSecondJumpPossible;

//For disabling auto pickup, custom varialbe, will affect Pawn.bCanPickupInventory
var config bool bDisableAutoPickup;

//By this default pawn speed will be multiplied ranges from 0.1 to 2
var config float SpeedMultiplier;

//helper variable to store the direction we want to go with CMOVE
var vector cmoveDirection;

//You need also to enable text to speech in UT2004 settings
var config bool bSpeakingBots;

//this is here, so we can properly debug the bot in java. it is the adress we need
//to connect to in order to debug the bot (in Pogamut the bots are now run each one in
//different JVM)
var string jmx;


/* UnderLift()
called by mover when it hits a pawn with that mover as its pendingmover while moving to its destination
Not usefull for us, but overriding at least. :-/
*/
function UnderLift(Mover M)
{
//	myConnection.SendLine("UNDLFT {Id " $ M $ "}");
}

//override - using translocator in this function
event NotifyMissedJump()
{
	// SENDMESSAGE
	// !!! possible new message?

}

//Whenever we got some adrenaline
function AwardAdrenaline(float Amount)
{
	super.AwardAdrenaline(Amount);
	//Removed, because can be accesed from SLF message (monitoring the change)
	//myConnection.SendLine("ADG"$ib$as$"Amount"$ib$Amount$ae);
}


//override - using translocator in this function
function Actor FaceActor(float StrafingModifier)
{
	return none;
}


//Called at the start of the match
function StartMatch()
{
	// SENDMESSAGE
	// !!! possible new message
}


//Spawns a pickup class on the bot possition - if able the bot will collect the
//item instantly, otherwise it dissapears after 2 seconds
function pickup SpawnInventory( class<pickup> PickupType )
{
	local Pickup Copy;
//	local inventory Inv;

	if (Pawn == None)
		return None;

	Copy = Spawn(PickupType,Pawn,,Pawn.Location,rot(0,0,0));
	Copy.bDropped = true;
	Copy.LifeSpan = 2;

	return Copy;
}

//This function will properly destroy the pawn of this conroller (otherwise conflicts with game mechanics)
function DestroyPawn()
{
	if (Pawn == None)
		return;

	Pawn.Died(none, class'DamageType', Pawn.Location);
}

//This function is called by the RESPAWN command - it makes sure everything will work ok
function RespawnPlayer(optional vector startLocation, optional rotator startRotation)
{
	if (IsInState('Dead') && !bAutoSpawn) //
	{
		RemoteRestartPlayer(startLocation,startRotation);
	}
	else if (bAutoSpawn)
	{
		bAutoSpawn = false; //otherwise it would get respawned in Dead state without specifyed locatin, rotation
		DestroyPawn();
		GotoState('Dead');
		RemoteRestartPlayer(startLocation,startRotation);
		bAutoSpawn = true;

	}
	else  if (!IsInState('Dead') && !bAutoSpawn)
	{
		DestroyPawn();
		GotoState('Dead');
		RemoteRestartPlayer(startLocation,startRotation);

	}
}

//This function handles actual bot respawning - when it dies for instance
function RemoteRestartPlayer(optional vector startLocation, optional rotator startRotation)
{
	if( Level.Game.isA('BotDeathMatch'))
	{
		BotDeathMatch(Level.Game).RemoteRestartPlayer( self, startLocation, startRotation );
	}

	if (Pawn != None)
	{
		gotostate('StartUp','DoStop');
	}
	else
	{
		log("Pawn is None after ResartPlayer");
	}

}

//Function which determines if our weapon should fire again or stop firing
function bool WeaponFireAgain(float RefireRate, bool bFinishedFire)
{

	if (!RemoteHasAmmo())
	{
		Super.StopFiring();
		return false;
	}

	return true;
}

//Use from local code - stops firing and ticks weapon to let it stop
function HaltFiring()
{
	//Pawn.Weapon.StopFire(Pawn.Weapon.BotMode);
	bFire = 0;
	bAltFire = 0;
	Super.StopFiring();
	//Pawn.Weapon.Tick(0.001);
}

//we have to override this function, otherwise US will reset our vision settings
//and etc..
function ResetSkill()
{
	//log("We are in ResetSkill");
}

//Overriding function, otherwise code from states in Bot.uc would be executed
function HearPickup(Pawn Other)
{
	//myConnection.SendLine("HRP" $ib$as$"Rotation" $ib$ rotator(Location - Other.Location) $ae);
}

//Overriding function, otherwise code from states in Bot.uc would be executed
function HearNoise (float Loudness,actor Actor )
{

}

//Called when our bot may hear some sound.
event AIHearSound( actor Actor, int Id, sound S, vector SoundLocation, vector Parameters, bool Attenuate ) {

	local float floatDist;
	local string prefix;
	local vector myLocation;

 	if (Pawn == none)
		return;

   	//log("NOISE - parameters "$Parameters);

	floatDist = sqrt(square(Pawn.Location.x - Actor.Location.x) + square(Pawn.Location.y - Actor.Location.y) + square(Pawn.Location.z - Actor.Location.z));

	if (floatDist > S.BaseRadius)
		return;

	if( Actor.IsA('Pickup') )
    	prefix = "HRP";
    else
    	prefix = "HRN";

	if (Pawn != none){
		myLocation = Pawn.Location;
	}
	else
	{
		myLocation = Location;
	}


	myConnection.SendLine(prefix $ " {Source " $ myConnection.GetUniqueId(Actor) $
		"} {Type " $ actor.Class $
		"} {Rotation " $ rotator(actor.Location - myLocation) $
		"}");

}

event SoakStop(string Problem)
{
	myConnection.SendLine("SOAKED {Problem " $ Problem $"}");
	log("We are Soaked! Problem: "$Problem);
}

//Zone the bot is standing on has changed
singular event BaseChange()
{
	Super(Pawn).BaseChange();
	// !!! possible SENDMESSAGE
	//myConnection.SendLine("BASETEST" $ib$as$ "Actor" $ib$ HitActor $ae$ib$as$"Location" $ib$ HitLocation $ae);
}


//Called right before bot falls off something
//If bot running, set bCanJump to true - let him fall
//if walking, won't fall
event MayFall()
{
	local bool bFall;

	bFall = !Pawn.bIsWalking;

	if(!bfall)
	{
		GotoState('Startup', 'Begin');
	}

	myConnection.SendLine("FAL {Fell " $ bFall $
		"} {Location " $ Pawn.Location $
		"}");

	Pawn.bCanJump = bFall;
}

//Called when the bot land on the ground after falling
function bool NotifyLanded(vector HitNormal)
{
	myConnection.SendLine("LAND {HitNormal " $ HitNormal $ "}");

	//restart, so we continue moving and not going back to our previous
	//destination, as we may be over it because of the fall
	if (movingContinuous)
		gotoState('StartUp','MoveContRepeat');
}

//TODO: This function returns wrong numbers - reimplement?
function float GetSpeed()
{
	if(Pawn.bIsWalking)
	{
		return Pawn.WalkingPct;
	}
	else
	{
		return 1.0;
	}
}

//can be autocalled when bot is shot by team mate
function YellAt(Pawn Moron);

function HandlePlayerInput(PlayerController inputPlayer, int Key)
{
	local string temp;

	temp = "";
	if (inputPlayer.IsA('GBxPlayer') && GBxPlayer(inputPlayer).DialogId != "")
		temp = " {DialogId " $ GBxPlayer(inputPlayer).DialogId $ "}";

	myConnection.SendLine( "PLI {Id " $ myConnection.GetUniqueId(inputPlayer) $
		"} {Key " $ Key $
		"}" $ temp);


}

//This is called from GBxPawn, so we get virtual IPK message also for inventory that is
//added for bot at the beginning of the game, otherwise we would have problems with counting
//ammunition and so
function HandleStartPickup(class<Pickup> PickupClass)
{
	local string InventoryId;
	local string temp, CheatId, mapId;
	local bool bDivided;

	InventoryId = string(Pawn.FindInventoryType(PickupClass.default.InventoryType));

    BotDeathMatch(Level.Game).GameBotsID++;

    //We create custom id that will look like normal id
    bDivided = true;
    CheatId = string(PickupClass);
    while (bDivided)
    {
		bDivided = Divide(CheatId, ".", temp, CheatId);
	}

	Divide(string(Level), ".", mapId, temp);

    CheatId = mapId $ "." $ CheatId $ BotDeathMatch(Level.Game).GameBotsID;

	myConnection.SendLine("IPK {Id " $ CheatId $
		"} {InventoryId " $ InventoryId $
		"} {Location " $ Pawn.Location $
		"} {Dropped " $ PickupClass.default.bDropped $
		"} {Type " $ PickupClass $
		"}");
}

//Called each time we have picked up something - ammo, weapon, health etc.
function HandlePickup(Pickup Pickup)
{
	local string InventoryId;

	InventoryId = string(Pawn.FindInventoryType(Pickup.InventoryType));

	myConnection.SendLine("IPK {Id " $ myConnection.GetUniqueId(Pickup) $
		"} {InventoryId " $ InventoryId $
		"} {Location " $ Pickup.Location $
		"} {Amount " $ myConnection.GetItemAmount(Pickup) $
		"} {Dropped " $ Pickup.bDropped $
		"} {Type " $ Pickup.Class $
		"}");
}

// Called when get new weapon or ammunition for weapon we do not have yet.
// Called just once per weapon type or per new ammunition type (notify new object in our inventory, NOT pickup)
// For exporting weapons we have new attributes.
function NotifyAddInventory( Inventory inputInventory )
{
	local string outstring;

	//For weapons
	local Weapon inputWeapon;
	local bool bUseAlternateAmmo;

	Super.NotifyAddInventory(inputInventory);

    outstring = "AIN {Id " $ myConnection.GetUniqueId(inputInventory) $
		"} {Type " $ inputInventory.class $
		"} {PickupType " $ inputInventory.PickupClass $
		"}";

	myConnection.SendLine(outstring);
}

function SetHealth(int amount)
{
	if (Pawn == none)
		return;
	if ((amount > 0) && (amount < 200))
		Pawn.Health = amount;
}

function SetAdrenaline(int amount)
{
	if ((amount > 0) && (amount <= 100))
		Adrenaline = amount;
}

function BotVoiceMessage(name messagetype, byte MessageID, Controller Sender);

// !!! need functions to send arbitrary string messages

function SendVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messageType, byte messageID, name broadcastType)
{
	super.SendVoiceMessage( Sender, Recipient, messageType, messageID, broadcastType );
}

//functions to send tokenized messages
/*
function SendTeamMessage(PlayerReplicationInfo Recipient, name MessageType, byte MessageID, float Wait)
{
	//log(self@"Send message"@MessageType@MessageID@"at"@Level.TimeSeconds);
	if ( (MessageType == OldMessageType) && (MessageID == OldMessageID)
		&& (Level.TimeSeconds - OldMessageTime < Wait) )
		return;

	//log("Passed filter");
	OldMessageID = MessageID;
	OldMessageType = MessageType;

	SendVoiceMessage(PlayerReplicationInfo, Recipient, MessageType, MessageID, 'TEAM');
}*/
/*
function SendGlobalMessage(PlayerReplicationInfo Recipient, name MessageType, byte MessageID, float Wait)
{
	//log(self@"Send message"@MessageType@MessageID@"at"@Level.TimeSeconds);
	if ( (MessageType == OldMessageType) && (MessageID == OldMessageID)
		&& (Level.TimeSeconds - OldMessageTime < Wait) )
		return;

	//log("Passed filter");
	OldMessageID = MessageID;
	OldMessageType = MessageType;

	SendVoiceMessage(PlayerReplicationInfo, Recipient, MessageType, MessageID, 'GLOBAL');
}*/


//handles sending messages to all and to team
function RemoteBroadcast( string Id, coerce string Msg, bool bGlobal, float FadeOut )
{

	local Controller C;
	local string MsgForVoice;

	MsgForVoice = Msg;
	if (bIncludeFadeOutInMsg)
		Msg = Msg $ " FadeOut=" $ FadeOut $ " s.";


    //Set the text bubble, which will be shown on the HUDs of Human players
    //when they see the bot
    if (Pawn != none)
   	{
   		if (bSpeakingBots)
	   		Pawn.TextToSpeech( MsgForVoice, 10 );
		GBxPawn(Pawn).SetTextBubble(Id, Msg, bGlobal, FadeOut);
	}

	if (Id != "")
	{
		for (C = Level.ControllerList; C != none; C=C.NextController)
		{
			if ( (C $ C.PlayerReplicationInfo.PlayerId) == Id)
			{
				if (C.IsA('RemoteBot'))
					RemoteBot(C).RemoteNotifyTeamMessage(self,"Private:"$Msg);
				//TODO: What if the reciever is a player?

       			return;
			}
		}

		//If we haven't found Id or Id doesn't belong to RemoteBot we will end
		return;
	}

	if ( bGlobal || !Level.Game.bTeamGame )
	{
	    //Send the message to the game channel
	    Level.Game.Broadcast(self, Msg, 'Say');
	    //Send the message to RemoteBots
	    SendGlobalMessage( Msg );
	    return;
	}

	if (Level.Game.bTeamGame)
	{
		//Send the message to team channel
		Level.Game.BroadcastTeam(self, Msg, 'TeamSay');
		//Send the message to RemoteBots
		SendTeamMessage( Msg );
		return;
	}
}

//Event for receiving string messages, called manually
event RemoteNotifyClientMessage( Controller C, coerce string S )
{
	//Could cause some parsing problems, so replacing
	S = Repl(S, "{", "_", false );
	S = Repl(S, "}", "_", false );

	myConnection.SendLine("VMS {Id "$ myConnection.GetUniqueId(C) $
		"} {Name " $ C.PlayerReplicationInfo.PlayerName $
		"} {Text " $ S $"}");
}

//Event for receiving string messages, called manually
event RemoteNotifyTeamMessage( Controller C, coerce string S )
{
	//Could cause some parsing problems, so replacing
	S = Repl(S, "{", "_", false );
	S = Repl(S, "}", "_", false );

	myConnection.SendLine("VMT {Id "$ myConnection.GetUniqueId(C) $
		"} {Name " $ C.PlayerReplicationInfo.PlayerName $
		"} {Text " $ S $"}");
}

//Send the team message to RemoteBots
function SendTeamMessage( string S )
{
	local Controller C;

	for( C = Level.ControllerList; C != None; C = C.NextController )
	{
		if( C.PlayerReplicationInfo.Team != none )
		{
			if( C.isA('RemoteBot') && C != self && C.PlayerReplicationInfo.Team.TeamIndex == PlayerReplicationInfo.Team.TeamIndex)
			{
				RemoteBot(C).RemoteNotifyTeamMessage( self , S );
			}
		}
	}
}

//Send the global message to RemoteBots
function SendGlobalMessage( string S )
{
	local Controller C;

	for( C = Level.ControllerList; C != none; C = C.NextController )
	{
		if( C.isA('RemoteBot') && C != self )
		{
			RemoteBot(C).RemoteNotifyClientMessage( self , S);
		}
	}
}

//other code may try to call this. make sure nada happens
//!!! need to change - make sure orders are actually recorded somewhere
//             for reference
function SetOrders(name NewOrders, Controller OrderGiver);

//events that are called when head, feet or whole bot changes zones
//e.g. air to water or lava
//only way to tell if underwater until drowning damage starts
/*
function FootZoneChange(ZoneInfo newFootZone)
{
	Super.FootZoneChange(newFootZone);

	myConnection.SendLine("ZCF" $ib$as$ "Id" $ib$ newFootZone $ae);
}
function HeadZoneChange(ZoneInfo newHeadZone)
{
	Super.HeadZoneChange(newHeadZone);

	myConnection.SendLine("ZCH" $ib$as$ "Id" $ib$ newHeadZone $ae);
} */

//The bot (or some part of the bot - legs) entered new volume
event bool NotifyPhysicsVolumeChange( PhysicsVolume NewVolume )
{

	//this code is taken from super class (Bot). Had to disable automatic jumping out of water
	//super class is not called anymore
	if ( newVolume.bWaterVolume )
	{
		bPlannedJump = false;
		if (!Pawn.bCanSwim)
			MoveTimer = -1.0;
		else if (Pawn.Physics != PHYS_Swimming)
			Pawn.setPhysics(PHYS_Swimming);
	}
	else if (Pawn.Physics == PHYS_Swimming)
	{
		if ( Pawn.bCanFly )
			 Pawn.SetPhysics(PHYS_Flying);
		else
		{
			Pawn.SetPhysics(PHYS_Falling);
			/*if ( Pawn.bCanWalk && (Abs(Pawn.Acceleration.X) + Abs(Pawn.Acceleration.Y) > 0)
				&& (Destination.Z >= Pawn.Location.Z)
				&& Pawn.CheckWaterJump(jumpDir) )
			{
				Pawn.JumpOutOfWater(jumpDir);
				bNotifyApex = true;
				bPendingDoubleJump = true;
			}*/
		}
	}

	myConnection.SendLine("VCH {Id " $ myConnection.GetUniqueId(NewVolume) $
		"} {ZoneVelocity " $ NewVolume.ZoneVelocity $  //vector
		"} {ZoneGravity " $ NewVolume.Gravity $  //vector
		"} {GroundFriction " $ NewVolume.GroundFriction $  //float
		"} {FluidFriction " $ NewVolume.FluidFriction $  //float
		"} {TerminalVelocity " $ NewVolume.TerminalVelocity $  //float
		"} {WaterVolume " $ NewVolume.bWaterVolume $
		"} {PainCausing " $ NewVolume.bPainCausing $
		"} {Destructive " $ NewVolume.bDestructive $
		"} {DamagePerSec " $ NewVolume.DamagePerSec $ //float
		"} {DamageType " $ NewVolume.DamageType $
		"} {NoInventory " $ NewVolume.bNoInventory $
		"} {MoveProjectiles " $ NewVolume.bMoveProjectiles $
		"} {NeutralZone " $ NewVolume.bNeutralZone $
		"}");

	return false;

}

//The bot entered a new zone
function ZoneChange(ZoneInfo newZone)
{
	Super.ZoneChange(newZone);
	if (myConnection == none)
		return;
	myConnection.SendLine("ZCB {Id " $ myConnection.GetUniqueId(NewZone) $ "}");
}

//Not used yet - should we use this somewhere?
function GetPhysicsVolume()
{
	local PhysicsVolume V, winner;

	winner = none;

	ForEach TouchingActors(class'PhysicsVolume',V)
	{
		if (winner == none)
			winner = V;
		else
		{
			if (winner.Priority < V.Priority )
			{
				winner = V;
			}
		}
	}

	if (winner != none)
		NotifyPhysicsVolumeChange( winner );
	else
		myConnection.SendLine("VCH {Id None}");

}

//Called when weapon is switched - may happen automatically
function ChangedWeapon()
{
//	local int usealt;

	if ( (Pawn.Weapon != none) && (Pawn.Weapon == Pawn.PendingWeapon) )
	{
		SwitchToBestWeapon();
		if ( Pawn.Weapon.GetStateName() == 'DownWeapon' )
			Pawn.Weapon.GotoState('Idle');
		Pawn.PendingWeapon = None;
	}
	else
		super.ChangedWeapon();

	if ( Pawn.Weapon != None )
	{
		if (bFire > 0)
		{
 			bAltFire = 0;
			bFire = 1;
			Pawn.Weapon.Fire(1.0);
		}
 		else if (bAltFire > 0)
 		{
			bAltFire = 0;
			bFire = 1;
			Pawn.Weapon.AltFire(1.0);
		}
		Pawn.Weapon.SetHand(0);

	}
	// !!! use or just make people get from status update
	myConnection.SendLine("CWP {Id " $ myConnection.GetUniqueId(Pawn.Weapon) $
				"} {PrimaryAmmo " $ Pawn.Weapon.AmmoAmount(0) $
				"} {SecondaryAmmo " $ Pawn.Weapon.AmmoAmount(1) $
				"} {Type " $ Pawn.Weapon.Class $"}");
}

event Touch( Actor Other )
{
	//TODO: Add a check if actor is a player or bot
	myConnection.SendLine("TCH {Id " $ myConnection.GetUniqueId(Other) $
							"} {Location " $ Other.Location $
							"} {Rotation " $ Other.Rotation $"}");
}

// called from pathnodes that unitelligent creatures are supposed to avoid
function FearThisSpot(AvoidMarker aSpot);

//called on hitting a wall
event bool NotifyHitWall( vector HitNormal, actor HitWall )
{
	if ( Level.TimeSeconds - 0.5 >= lastWallHitTime )
	{
		myConnection.SendLine("WAL {Id " $ myConnection.GetUniqueId(HitWall) $
			"} {Normal " $ HitNormal $
			"} {Location " $ Pawn.Location $"}");

		lastWallHitTime = Level.TimeSeconds;
	}

	return true;
}


//called on collisions with other actors
event bool NotifyBump(actor Other)
{
	local vector VelDir, OtherDir;
	local float speed;

	if ( TimerRate <= 0 )
		setTimer(1.0, false);

	speed = VSize(Velocity);
	if ( speed > 10 )
	{
		VelDir = Velocity/speed;
		VelDir.Z = 0;
		OtherDir = Other.Location - Location;
		OtherDir.Z = 0;
		OtherDir = Normal(OtherDir);
		if ( (VelDir Dot OtherDir) > 0.8 )
		{
			Velocity.X = VelDir.Y;
			Velocity.Y = -1 * VelDir.X;
			Velocity *= FMax(speed, 280);
		}
	}

	if ( Level.TimeSeconds - 0.5 >= lastBumpTime )
	{

		myConnection.SendLine("BMP {Id " $ myConnection.GetUniqueId(Other) $
			"} {Location " $ Other.Location $"}");

		lastBumpTime = Level.TimeSeconds;
	}

	// Need to disable bumping ???
	//Disable('Bump');
	//TODO: Experiment with this?
	return false;
}

//called periodicaly for each player in view
function SeePlayer(Pawn SeenPlayer)
{
/* Temporary suspended - for now
	local Controller C;
	local string TeamIndex, OutString, WeaponClass;

	if (SeenPlayer == none)
		return;

   	C = SeenPlayer.Controller;

	if(Level.Game.isA('BotTeamGame'))
	{
		TeamIndex = string(C.PlayerReplicationInfo.Team.TeamIndex);
	}
	else
	{
		TeamIndex = "255";
	}
	if (C.Pawn.Weapon != none)
	{
		WeaponClass = string(C.Pawn.Weapon.Class);
	}
	else
	{
		WeaponClass = "None";
	}
	outstring = "PLR {Id " $ myConnection.GetUniqueId(C) $
		"} {Rotation " $ C.Pawn.Rotation $
		"} {Location " $ C.Pawn.Location $
		"} {Velocity " $ C.Pawn.Velocity $
		"} {Name " $ C.PlayerReplicationInfo.PlayerName $
		"} {Team " $ TeamIndex $
		"} {Reachable " $ actorReachable(C.Pawn) $
		"} {Weapon " $ WeaponClass $
		"}";

	if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(0).IsFiring() )
		outstring = outstring $" {Firing 1}";
	else if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(1).IsFiring() )
		outstring = outstring $" {Firing 2}";
	else
		outstring = outstring $" {Firing 0}";

	myConnection.sendLine(outstring);
*/
}

function RemotePickup(Pickup inputPickup)
{
	local Pickup P;

	if (Pawn != none && bDisableAutoPickup)
	{
		foreach Pawn.TouchingActors(class'Pickup', P)
		{
			if (P == inputPickup)
			{
				Pawn.bCanPickupInventory = true;
				inputPickup.Touch(Pawn);
				Pawn.bCanPickupInventory = false;
			}
		}
	}
}

/* Added func RemoteKilled - should make things cleaner, called from GameTypeGame server
	25.10.2006 Michal Bida
*/
function RemoteKilled(Controller Killer, Controller Killed, Pawn KilledPawn, class<DamageType> damageType)
{
	local string outstring;

	outstring = "KIL {Id " $ myConnection.GetUniqueId(Killed) $
		"} {KilledPawn " $ KilledPawn $
        "} {Killer " $ myConnection.GetUniqueId(Killer) $
		"}";
	if (CanSee(KilledPawn))
	{
		outstring = outstring $ " {DamageType " $ damageType $
        "} {DeathString " $ damageType.default.DeathString $
        "} {WeaponName " $ damageType.default.DamageWeaponName $
        "} {Flaming " $ damageType.default.bFlaming $
        "} {CausedByWorld " $ damageType.default.bCausedByWorld $
        "} {DirectDamage " $ damageType.default.bDirectDamage $
        "} {BulletHit " $ damageType.default.bBulletHit $
        "} {VehicleHit " $ damageType.default.bVehicleHit $
		"}";
	}

	myConnection.sendLine(outstring);
}

/* Added func RemoteDied - should make things cleaner, called from GameTypeGame server
	25.10.2006 Michal Bida
*/
function RemoteDied(Controller Killer, class<DamageType> damageType)
{
	myConnection.SendLine("DIE {Killer " $ myConnection.GetUniqueId(Killer) $
		"} {DamageType " $ damageType $
        "} {DeathString " $ damageType.default.DeathString $
        "} {WeaponName " $ damageType.default.DamageWeaponName $
        "} {Flaming " $ damageType.default.bFlaming $
        "} {CausedByWorld " $ damageType.default.bCausedByWorld $
        "} {DirectDamage " $ damageType.default.bDirectDamage $
        "} {BulletHit " $ damageType.default.bBulletHit $
        "} {VehicleHit " $ damageType.default.bVehicleHit $
		"}");
}

/* NearWall() returns true if there is a nearby barrier at eyeheight, and
changes Focus to a suggested value
*/
//Potentially usefull
/*
function bool NearWall(float walldist)
{
	local actor HitActor;
	local vector HitLocation, HitNormal, ViewSpot, ViewDist, LookDir;

	LookDir = vector(Rotation);
	ViewSpot = Location + BaseEyeHeight * vect(0,0,1);
	ViewDist = LookDir * walldist;
	HitActor = Trace(HitLocation, HitNormal, ViewSpot + ViewDist, ViewSpot, false);
	if ( HitActor == None )
		return false;

	ViewDist = Normal(HitNormal Cross vect(0,0,1)) * walldist;
	if (FRand() < 0.5)
		ViewDist *= -1;

	if ( FastTrace(ViewSpot + ViewDist, ViewSpot) )
	{
		Focus = Location + ViewDist;
		return true;
	}

	ViewDist *= -1;

	if ( FastTrace(ViewSpot + ViewDist, ViewSpot) )
	{
		Focus = Location + ViewDist;
		return true;
	}

	Focus = Location - LookDir * 300;
	return true;
}
*/

//Do adrenaline combo
function RemoteCombo( string ComboClassName )
{
	if ((Pawn != none) && !Pawn.InCurrentCombo() && (Adrenaline == AdrenalineMax) )
		Pawn.DoComboName( ComboClassName );
}

//Jumps a bot
function RemoteJump(bool bDouble)
{

	if (Pawn == none)
		return;

	if (Pawn.Physics != PHYS_Falling)  //TODO: Check all bad physics
	{
		Pawn.DoDoubleJump(true);

		if (bDouble)
		{
			//Pawn.Velocity = EAdjustJump(xPawn(Pawn).JumpZ + xPawn(Pawn).MultiJumpBoost,0);
			Pawn.Velocity.z += xPawn(Pawn).JumpZ;// + xPawn(Pawn).MultiJumpBoost;
			//EAdjustJump(0,Pawn.GroundSpeed);
			//EAdjustJump(Pawn.Velocity.Z,Pawn.GroundSpeed);
			//Pawn.DoDoubleJump(true);
		}
	}
}

//Intercept FireWeapon - is called from other code
function FireWeapon();

function bool RemoteHasAmmo()
{
	if ( (Pawn == none) || (Pawn.Weapon == none) )
		return false;

	if (bFire == 1)
	{
		return (Pawn.Weapon.AmmoAmount(0) >= Pawn.Weapon.GetFireMode(0).AmmoPerFire);
	}

	if (bAltFire == 1)
	{
		return (Pawn.Weapon.AmmoAmount(1) >= Pawn.Weapon.GetFireMode(1).AmmoPerFire);
    }
}

function RemoteFireWeapon(bool bUseAltMode)
{

	if ((Pawn == none) || (Pawn.Weapon == none))
		return;

	//If we are changing from one firing mode to another we need to stopshooting
	if (bUseAltMode && (bFire == 1))
		super.StopFiring();
	else if (!bUseAltMode && (bAltFire == 1))
		super.StopFiring();


	if ( !bUseAltMode )
	{
		bFire = 1;
		bAltFire = 0;
		if (!RemoteHasAmmo())
		{
			bFire = 0;
			return;
		}
    	Pawn.Weapon.BotMode = 0;
    	Pawn.Weapon.StartFire(0);
	}
	else
	{
		bFire = 0;
		bAltFire = 1;
		if (!RemoteHasAmmo())
		{
			bAltFire = 0;
			return;
		}
    	Pawn.Weapon.BotMode = 1;
    	Pawn.Weapon.StartFire(1);
	}

}

// check for line of sight to target deltatime from now.
//used by missle launcher and others to abort firing
// may want to reimplement
function bool CheckFutureSight(float deltatime)
{
	return true;
}

/*
AdjustAim()
Returns a rotation which is the direction the bot should aim - after introducing the appropriate aiming error
*/
function rotator AdjustAim(FireProperties FiredAmmunition, vector projStart, int aimerror)
{
	local rotator FireRotation, TargetLook;
	local float FireDist, TargetDist, ProjSpeed;
	local actor HitActor;
	local vector FireSpot, FireDir, TargetVel, HitLocation, HitNormal;
	local int realYaw;
	local bool bDefendMelee, bClean, bLeadTargetNow;

	if ( FiredAmmunition.ProjectileClass != None )
		projspeed = FiredAmmunition.ProjectileClass.default.speed;

	//log("AIMError is "$aimerror);
	// make sure bot has a valid target

	// This means we want to shoot at location
	if ( Target == None )
	{
		//we will set our own FocusActor as a target
		Target = myTarget;
	}

	//if our target is our FocusActor, we want to update its position - if not locked
	//(according to bots new focal point due to rotation, movement, etc.)
	if ( (Target == myTarget) && !bTargetLocationLocked)
		myTarget.SetLocation(myFocalPoint);

	/*
	if ( Target == None )
	{
		Target = Enemy;
		if ( Target == None ) //shooting at a location
		{

			//HACK: We will set ShotTarget to ourselves, so the projectile calls
			//ReceiveProjectileWarning on us and we will distribute it to other bots
			ShotTarget = Pawn;

			//TODO: Why to do this?
			//SetRotation( Rotator( myFocalPoint ));
			FireSpot = myFocalPoint;
			TargetDist = VSize(myFocalPoint - Pawn.Location);

			if (!bPerfectLocationAim)
				aimerror = AdjustAimError(aimerror,TargetDist,false,FiredAmmunition.bInstantHit, false);

			if ( Pawn(Target) == None )
			{
				if ( !FiredAmmunition.bTossed )
				{

					FireRotation = rotator(myFocalPoint - projstart);
					realYaw = FireRotation.Yaw;
					if (!bPerfectLocationAim)
						FireRotation.Yaw = SetFireYaw(FireRotation.Yaw + aimerror);
    				SetRotation(FireRotation);
    				UpdatePawnViewPitch();
					return FireRotation;
				}
				else
				{
					FireDir = AdjustToss(projspeed,ProjStart,myFocalPoint,true);
					FireRotation = Rotator(FireDir);
					realYaw = FireRotation.Yaw;
					if (!bPerfectLocationAim)
						FireRotation.Yaw = SetFireYaw(FireRotation.Yaw + aimerror);

					SetRotation(FireRotation);
					UpdatePawnViewPitch();
					return FireRotation;
				}
			}

		}
	}             */

	//TODO: We have target defined - Comment lines below out?
	//if ( Pawn(Target) != None )
		//Target = Pawn(Target).GetAimTarget();

	FireSpot = Target.Location;
	TargetDist = VSize(Target.Location - Pawn.Location);


	// Here we are aiming at stationary objects( not a location, not a pawn)
	if ( Pawn(Target) == None )
	{
		// if bPerfectLocationAim is true, it means that no aim correction will be performed on staitonary objects
		if (!bPerfectLocationAim)
			aimerror = AdjustAimError(aimerror,TargetDist,false,FiredAmmunition.bInstantHit, false);

		if ( !FiredAmmunition.bTossed )
		{

			FireRotation = rotator(Target.Location - projstart);
			realYaw = FireRotation.Yaw;
			if (!bPerfectLocationAim)
				FireRotation.Yaw = SetFireYaw(FireRotation.Yaw + aimerror);
			SetRotation(FireRotation);
			UpdatePawnViewPitch();
			return FireRotation;

		}
		else
		{
			FireDir = AdjustToss(projspeed,ProjStart,Target.Location,true);

			FireRotation = Rotator(FireDir);
			realYaw = FireRotation.Yaw;
			if (!bPerfectLocationAim)
				FireRotation.Yaw = SetFireYaw(FireRotation.Yaw + aimerror);

			SetRotation(FireRotation);
			UpdatePawnViewPitch();
			return FireRotation;

		}
	}

	bLeadTargetNow = FiredAmmunition.bLeadTarget && bLeadTarget;
	bDefendMelee = ( (Target == Enemy) && DefendMelee(TargetDist) );
	aimerror = AdjustAimError(aimerror,TargetDist,bDefendMelee,FiredAmmunition.bInstantHit, bLeadTargetNow);

	// lead target with non instant hit projectiles
	if ( bLeadTargetNow )
	{
		TargetVel = Target.Velocity;

		// hack guess at projecting falling velocity of target
		if ( Target.Physics == PHYS_Falling )
		{
			if ( Target.PhysicsVolume.Gravity.Z <= Target.PhysicsVolume.Default.Gravity.Z )
				TargetVel.Z = FMin(TargetVel.Z + FMax(-400, Target.PhysicsVolume.Gravity.Z * FMin(1,TargetDist/projSpeed)),0);
			else
			{
				//TODO: Correct?
				TargetVel.Z = FMin(0, TargetVel.Z);
			}
		}

		if ( bLeadTargetNow )
		{
			// more or less lead target (with some random variation)
			FireSpot += FMin(1, 0.7 + 0.6 * FRand()) * TargetVel * TargetDist/projSpeed;
			FireSpot.Z = FMin(Target.Location.Z, FireSpot.Z);
		}
		if ( (Target.Physics != PHYS_Falling) && (FRand() < 0.55) && (VSize(FireSpot - ProjStart) > 1000) )
		{
			// don't always lead far away targets, especially if they are moving sideways with respect to the bot
			TargetLook = Target.Rotation;
			if ( Target.Physics == PHYS_Walking )
				TargetLook.Pitch = 0;
			bClean = ( ((Vector(TargetLook) Dot Normal(Target.Velocity)) >= 0.71) && FastTrace(FireSpot, ProjStart) );
		}
		else // make sure that bot isn't leading into a wall
			bClean = FastTrace(FireSpot, ProjStart);
		if ( !bClean)
		{
			// reduce amount of leading
			if ( FRand() < 0.3 )
				FireSpot = Target.Location;
			else
				FireSpot = 0.5 * (FireSpot + Target.Location);
		}
	}

	bClean = false; //so will fail first check unless shooting at feet
	if ( FiredAmmunition.bTrySplash && (Pawn(Target) != None) && ((Skill >=4) || bDefendMelee)
		&& (((Target.Physics == PHYS_Falling) && (Pawn.Location.Z + 80 >= Target.Location.Z))
			|| ((Pawn.Location.Z + 19 >= Target.Location.Z) && (bDefendMelee || (skill > 6.5 * FRand() - 0.5)))) )
	{
	 	HitActor = Trace(HitLocation, HitNormal, FireSpot - vect(0,0,1) * (Target.CollisionHeight + 6), FireSpot, false);
 		bClean = (HitActor == None);
		if ( !bClean )
		{
			FireSpot = HitLocation + vect(0,0,3);
			bClean = FastTrace(FireSpot, ProjStart);
		}
		else
			bClean = ( (Target.Physics == PHYS_Falling) && FastTrace(FireSpot, ProjStart) );
	}
	if ( Pawn.Weapon != None && Pawn.Weapon.bSniping && Stopped() && (Skill > 5 + 6 * FRand()) )
	{
		// try head
 		FireSpot.Z = Target.Location.Z + 0.9 * Target.CollisionHeight;
 		bClean = FastTrace(FireSpot, ProjStart);
	}

	if ( !bClean )
	{
		//try middle
		FireSpot.Z = Target.Location.Z;
 		bClean = FastTrace(FireSpot, ProjStart);
	}
	if ( FiredAmmunition.bTossed && !bClean && bEnemyInfoValid )
	{
		FireSpot = LastSeenPos;
	 	HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
		if ( HitActor != None )
		{
			bCanFire = false;
			FireSpot += 2 * Target.CollisionHeight * HitNormal;
		}
		bClean = true;
	}

	if( !bClean )
	{
		// try head
 		FireSpot.Z = Target.Location.Z + 0.9 * Target.CollisionHeight;
 		bClean = FastTrace(FireSpot, ProjStart);
	}
	if ( !bClean && (Target == Enemy) && bEnemyInfoValid )
	{
		FireSpot = LastSeenPos;
		if ( Pawn.Location.Z >= LastSeenPos.Z )
			FireSpot.Z -= 0.4 * Enemy.CollisionHeight;
	 	HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
		if ( HitActor != None )
		{
			FireSpot = LastSeenPos + 2 * Enemy.CollisionHeight * HitNormal;
			if ( Pawn.Weapon != None && Pawn.Weapon.SplashDamage() && (Skill >= 4) )
			{
			 	HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
				if ( HitActor != None )
					FireSpot += 2 * Enemy.CollisionHeight * HitNormal;
			}
			if ( Pawn.Weapon != None && Pawn.Weapon.RefireRate() < 0.99 )
				bCanFire = false;
		}
	}

	// adjust for toss distance
	if ( FiredAmmunition.bTossed )
		FireDir = AdjustToss(projspeed,ProjStart,FireSpot,true);
	else
		FireDir = FireSpot - ProjStart;

	FireRotation = Rotator(FireDir);
	realYaw = FireRotation.Yaw;

	FireRotation.Yaw = SetFireYaw(FireRotation.Yaw + aimerror);
	FireDir = vector(FireRotation);
	// avoid shooting into wall
	FireDist = FMin(VSize(FireSpot-ProjStart), 400);
	FireSpot = ProjStart + FireDist * FireDir;
	HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
	if ( HitActor != None )
	{
		if ( HitNormal.Z < 0.7 )
		{
			FireRotation.Yaw = SetFireYaw(realYaw - aimerror);
			FireDir = vector(FireRotation);
			FireSpot = ProjStart + FireDist * FireDir;
			HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
		}
		if ( HitActor != None )
		{
			FireSpot += HitNormal * 2 * Target.CollisionHeight;
			if ( Skill >= 4 )
			{
				HitActor = Trace(HitLocation, HitNormal, FireSpot, ProjStart, false);
				if ( HitActor != None )
					FireSpot += Target.CollisionHeight * HitNormal;
			}
			FireDir = Normal(FireSpot - ProjStart);
			FireRotation = rotator(FireDir);
		}
	}
	InstantWarnTarget(Target,FiredAmmunition,vector(FireRotation));
	ShotTarget = Pawn(Target);

	SetRotation(FireRotation);
	UpdatePawnViewPitch();
	return FireRotation;
}

//Is this function meant to be called for instant hit projectiles?
function InstantWarnTarget(Actor Target, FireProperties FiredAmmunition, vector FireDir)
{
	super.InstantWarnTarget(Target, FiredAmmunition, FireDir);
    //log("In RemoteBot: InstantWarnTarget");
}

//Here we send PRJ message asynchronously
function ReceiveProjectileWarning(Projectile Proj)
{    // we send this as sync. message now too
	local Pawn Shooter;
	local vector FireDir;
	local float projDistance;
	//local float orientation;
	//local vector Q, HelpVec;
	//local vector aFacing,aToB;

		if (Proj.IsA('FlakChunk'))
			FireDir = Normal(Proj.Velocity);
		else
			FireDir = vector(Proj.Rotation);

		if ( LineOfSightTo(Proj) && inFront(Proj.Location))
		{

			projDistance = VSize(Pawn.Location - Proj.Location);

			myConnection.SendLine("PRJ {Id " $ myConnection.GetUniqueId(Proj) $
				"} {Time " $ (projDistance/Proj.Speed) $
				"} {Direction " $ FireDir $
				"} {Speed " $ Proj.Speed $
				"} {Velocity " $ Proj.Velocity $
				"} {Location " $ Proj.Location $
				"} {Origin " $ Proj.Instigator.Location $
				"} {DamageRadius " $ Proj.DamageRadius $
				"} {Type " $ Proj.Class $
				"}");
		}

            /*HelpVec = Proj.Location + FireDir * 500;

			//These lines were taken from UnrealWiki
        	//This counts the nearest point to our bot on the line created by origin of the projectile and his direction
			Q = Proj.Location + Normal( HelpVec - Proj.Location ) * ((( HelpVec - Proj.Location )
			dot ( Pawn.Location - Proj.Location )) / VSize( Proj.Location - HelpVec ));

			//Here we find out if Q is in front of shooter or behind him
			aFacing=Normal(FireDir);
 			aToB=Q - Proj.Location;
			orientation = aFacing dot aToB;
		//If the projectile flies at distance 100 or less from our bot we send the message
		//if ((orientation > 0) && (VSize( Pawn.Location - Q ) < 100))
		//{
		//	enemyDistance = VSize(Pawn.Location - shooter.Location);
		 //
		//	myConnection.SendLine("PRJ" $ib$as$ "Time" $ib$ (enemyDistance/Proj.Speed) $ae$ib$as$
		//		"Direction" $ib$ FireDir $ae$ib$as$
		//		"Origin" $ib$ Shooter.Location $ae$ib$as$
		//		"DamageRadius" $ib$ Proj.DamageRadius $ae$ib$as$
		//		"Type" $ib$ Proj.Class $ae);
		//}

		  */
}


// Projectiles are handled elsewhere
// This function is not just for projectiles, is called also from other code

/* Receive warning now only for instant hit shots and vehicle run-over warnings */

event ReceiveWarning(Pawn shooter, float projSpeed, vector FireDir)
{
	log("We ve been in ReceiveWarning");
	//TODO: New special projectiles message?

}

function bool TryToDuck(vector duckDir, bool bReversed);

// CloseToPointMan - called if orders are 'follow' to check if close enough to point man
function bool CloseToPointMan(Pawn Other)
{
	//return what engine wants to hear
	return true;
}

//Don't need our bots autotaunting
function MaybeTaunt(Pawn Other);

//Called when someone other than this bot dies.
//TODO: We dont need this
function Killed(pawn Killer, pawn Other, name damageType);

//Pointless callback
function EnemyAcquired();

//All kinds of things can call this mostly special trigger points
function Trigger( actor Other, pawn EventInstigator )
{
	myConnection.SendLine("TRG {Actor " $ myConnection.GetUniqueId(Other) $
		"} {EventInstigator " $ myConnection.GetUniqueId(EventInstigator) $
		"}");
}

//Much of translocator brains implemented in translocator
//For now better off playing without it - need to research how
//it interacts with path finding
function TranslocateToTarget(Actor Destn)
{
	//MyTranslocator.DesiredTarget = Destn;
}

//Don't let engine pick nodes that must be impact jumped
function bool CanImpactJump()
{
	return false;
}

//Don't handle impact jumps or low gravity manuevers for bots
function ImpactJump();
function BigJump(Actor JumpDest);

//Don't have engine direct to Ambush
function bool FindAmbushSpot()
{
	return false;
}

//Called when bot is injured
function NotifyTakeHit
(
	pawn InstigatedBy,
	vector HitLocation,
	int Damage,
	class<DamageType> damageType,
	vector Momentum
)
{
	local float enemyDist;
	local vector enemyDir, X, Y, Z;
	local string messageString;

	Super.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);

	messageString = "DAM {Damage " $ Damage $
		"} {DamageType " $ damageType $
        "} {WeaponName " $ damageType.default.DamageWeaponName $
        "} {Flaming " $ damageType.default.bFlaming $
        "} {CausedByWorld " $ damageType.default.bCausedByWorld $
        "} {DirectDamage " $ damageType.default.bDirectDamage $
        "} {BulletHit " $ damageType.default.bBulletHit $
        "} {VehicleHit " $ damageType.default.bVehicleHit $
		"}";

	//TODO: !!! need to fix this and projectile detection to match our
	//periphreal vision parameter.
	// only if tight FOV
	GetAxes(Rotation,X,Y,Z);
	enemyDist = VSize(instigatedBy.Location - Location);
	enemyDir = (instigatedBy.Location - Location)/enemyDist;

	if ((enemyDir Dot X) > 0.8)
		messageString = messageString $" {Instigator " $ myConnection.GetUniqueId(instigatedBy) $"}";

	myConnection.SendLine(messageString);

	//Here we notifyies RemoteBot about they made a hit.
	if( InstigatedBy != none && InstigatedBy.Controller != none && InstigatedBy.Controller.isA('RemoteBot'))
	{
	    RemoteBot(InstigatedBy.Controller).RemoteNotifyHit(self, Damage, DamageType );
    }
}

function RemoteNotifyHit(Controller Victim, int Damage, class<DamageType> damageType)
{
	myConnection.sendLine("HIT {Id " $ myConnection.GetUniqueId(Victim) $
		"} {Damage " $ Damage $
        "} {DamageType " $ DamageType $
        "} {WeaponName " $ damageType.default.DamageWeaponName $
        "} {Flaming " $ damageType.default.bFlaming $
        "} {DirectDamage " $ damageType.default.bDirectDamage $
        "} {BulletHit " $ damageType.default.bBulletHit $
        "} {VehicleHit " $ damageType.default.bVehicleHit $
		"}");
}


function SetFall()
{
	if (Pawn.bCanFly)
	{
		Pawn.SetPhysics(PHYS_Flying);
		return;
	}
	if (bDebug)
		log("In RemoteBot.uc: SetFall() enganged.");
	/*
	if ( Pawn.bNoJumpAdjust )
	{
		Pawn.bNoJumpAdjust = false;
		return;
	}
	else
	{
		bPlannedJump = true;
		Pawn.Velocity = EAdjustJump(Pawn.Velocity.Z,Pawn.GroundSpeed);
		Pawn.Acceleration = vect(0,0,0);
	} */
}


//**********************************************************************************
//Base RemoteBot AI, that controls the Pawn (makes him move)

auto state StartUp
{
	function BeginState()
	{
		//log("StartUp,BeginState");
		//TODO:HACK: Should examine Squad issues if it should be here

        movingContinuous = false;

		if (Squad == none)
			Squad = spawn(class'GBSquadAI');

		Squad.AddBot(self);

	}
Begin:
	movingContinuous = false;
    //This is necessary, because if someone keeps shooting on our bot,
	//sometimes it starts sliding to side
	//log("Physics "$Physics$"Pawn Physics "$Pawn.Physics);
	if (Pawn != none)
	{
		if (Pawn.Physics != PHYS_Falling)
		{
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0; //TODO: Should check what the hell is this
		}
	}
 	sleep(0.5);
	goto 'Begin';
DoStop:
	movingContinuous = false;
	if (Pawn != none)
	{
		if (Pawn.Physics == PHYS_Falling) //TODO: This is just a test, but it should repair one issue.
		{
			WaitForLanding(); //We wait when we are on ground and THEN we will stop.
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0;
		}
		else
		{
			Pawn.Velocity = vect(0,0,0);
			Pawn.Acceleration = vect(0,0,0);
			MoveTimer = -1.0; //TODO: Should check what the hell is this
		}
	}
	//Pawn.PlayWaiting();
	goto 'Begin';
MoveToActor:
	movingContinuous = false;
	if (Pawn != None)
	{
		MoveToward(MoveTarget, , , , Pawn.bIsWalking);
		//There is an issue when the bot finish its movement, sometimes he goes a bit
		//over the target point, this caused turning back, because moveTo functions sets focalpoint
		//after it ends to its target point, to prevent this, we will set our own FocalPoint counted in advance
		FocalPoint = myFocalPoint;
	}
	goto 'Begin';
Move: //Moves swiftly between two locations - could be a problem normaly because of TCP/IP delays
	movingContinuous = false;
	if (Pawn != None)
	{
		if (Focus == none)
		{
			MoveTo( myDestination, , Pawn.bIsWalking );
			MoveTo( pendingDestination, , Pawn.bIsWalking);
		}
		else
		{
			MoveTo( myDestination, Focus, Pawn.bIsWalking );
			MoveTo( pendingDestination, Focus, Pawn.bIsWalking);
		}
		//There is an issue when the bot finish its movement, sometimes he goes a bit
		//over the target point, this caused turning back, because moveTo functions sets focalpoint
		//after it ends to its target point, to prevent this, we will set our own FocalPoint counted in advance
		FocalPoint = myFocalPoint;
	}
	goto 'Begin';
MoveContinuous:
	if (Pawn != None)
	{
		//to prevent that our focal point moves too much above or below us
		//remember we want to move
		myFocalPoint.z = Pawn.Location.z;
	 	cmoveDirection = vector(rotator(myFocalPoint - Pawn.Location));
	}
MoveContRepeat:
	if (Pawn != None)
	{
		movingContinuous = true;
		MoveTo( Pawn.Location + 500 * cmoveDirection, , Pawn.bIsWalking );

		myFocalPoint = Pawn.Location + 500 * cmoveDirection;
		FocalPoint = myFocalPoint;
		goto 'MoveContRepeat';
	}
	goto 'Begin';
}

// This state was called somehow on our bot. That is highly undersirable.
// Overriding
state Roaming
{
	function BeginState()
	{
		//log("In Roaming STATE! Shouldnt be!");
		gotostate('StartUp','Begin');
	}
Begin:
	gotostate('StartUp','Begin');
}

state TakeHit
{
	//ignores seeplayer, hearnoise, bump, hitwall;

	function Timer();

Begin:
	error("!!!TakeHit");
}

state GameEnded
{
ignores SeePlayer, EnemyNotVisible, HearNoise, TakeDamage, Bump, Trigger, HitWall, ZoneChange, Falling, ReceiveWarning;

	function SpecialFire()
	{
	}
	function bool TryToDuck(vector duckDir, bool bReversed)
	{
		return false;
	}
	function SetFall()
	{
	}
	function LongFall()
	{
	}
	function Killed(pawn Killer, pawn Other, name damageType)
	{
	}
	function ClientDying(class<DamageType> DamageType, vector HitLocation)
	{
	}

	function BeginState()
	{
		Pawn.SimAnim.AnimRate = 0.0;
		bFire = 0;
		bAltFire = 0;

		SetCollision(false,false,false);
		SetPhysics(PHYS_None);
		Velocity = vect(0,0,0);
		myConnection.SendLine("FIN");
	}
}

state Dead
{
ignores SeePlayer, HearNoise, KilledBy;

function BeginState()
{
	//log("State: Dead, fc BeginState()");

	//We can be sent to this state sometimes, when it is not desired ( by game mechanics)
	//Escaping here
	if (Pawn != none)
		gotostate('StartUp','Begin');

	//This is taken from working AI in UT2004, probably needed to assure bot
	//will behave normally after restart - 02/03/07 Michal Bida
	movingContinuous = false;
	Enemy = None;
	Focus = None;
	Target = None;
	RouteGoal = None;
	MoveTarget = None;
	bFire = 0;
	bAltFire = 0;
	Super.StopFiring(); //Not needed anymore to call super, but for sure.
	FormerVehicle = None;
	bFrustrated = false;
	BlockedPath = None;
	bInitLifeMessage = false;
	bPlannedJump = false;
	bInDodgeMove = false;
	bReachedGatherPoint = false;
	bFinalStretch = false;
	bWasNearObjective = false;
	bPreparingMove = false;
	bEnemyEngaged = false;
	bPursuingFlag = false;



}
/*
function EndState()
{
	myConnection.sendLine("SPW2");
}*/
Begin:
	log("In Dead:Begin:");
	//AutoSpawn policy
	if (Pawn != None)
		gotostate('StartUp','Begin');

	if (bAutoSpawn)// && !Level.Game.bWaitingToStartMatch)
	{
		RemoteRestartPlayer();
	//	if (Pawn == none) //bug during restart?
	//		goto('Begin');
		//ServerRestartPlayer(); //Dunno if this is needed here - Could it cause troubles?
	}

	if (Pawn != None)
		gotostate('StartUp','Begin');
/*	if (!Level.Game.bWaitingToStartMatch)
	{
		RemoteRestartPlayer();
	}
	if (Pawn != None)
		gotostate('StartUp','Begin');*/
	sleep(1.0);
	goto('Begin');

}



//-------------RemoteBot Specific Functions--------------------


//Check to see if a location is really in front of the bot
//may be a more efficient algorithm
function bool inFront(Vector A)
{
	local rotator angle;

	//can't be infront if inside bot
	if( VSize(Pawn.Location - A) < CollisionRadius )
		return false;

	angle = ( Pawn.Rotation - rotator(A - Pawn.Location) );

	if( (cos(angle.Yaw / 10435.0) < remoteVisionLimit) ||
		(cos(angle.Pitch / 10435.0) < remoteVisionLimit) )
		return false;
	else
		return true;
}


//Called by the gametype when someone else is injured by the bot
//TODO: From old gamebots, is not called anymore, TO REMOVE - mb
/*
function int HurtOther(int Damage, name DamageType, pawn injured)
{
	myConnection.SendLine("HIT" $ib$as$ "Id" $ib$ injured $ae$ib$as$
		"Damage" $ib$ Damage $ae$ib$as$
		"DamageType" $ib$ DamageType $ae);
} */

function checkSelf()
{
	local string outstring, TeamIndex, altFiring;
	local rotator PawnRotation;
	local bool bIsShooting;

	local vector FloorLocation, FloorNormal;

	if(Level.Game.isA('BotTeamGame'))
	{
		TeamIndex = string(PlayerReplicationInfo.Team.TeamIndex);
	}
	else
	{
    	TeamIndex = "255";
	}

	//we are driving vehicle!
	if ( Vehicle(Pawn) != none )
	{
		PawnRotation = Pawn.Rotation;
		PawnRotation.Pitch = int(Pawn.ViewPitch) * 65556/255;

		FloorNormal = vect(0,0,0);
		Trace(FloorLocation,FloorNormal,Pawn.Location + vect(0,0,-1000),Pawn.Location, false, ,);

		outstring = "SLF {Id " $ myConnection.GetUniqueId(self) $
			"} {Vehicle True" $
			"} {Rotation " $ PawnRotation $
			"} {Location " $ Pawn.Location $
			"} {Velocity " $ Pawn.Velocity $
			"} {Name " $ PlayerReplicationInfo.PlayerName $
			"} {Team " $ TeamIndex $
			"} {Health " $ Pawn.Health $
			//dunno how to get this yet
			//"} {Shooting " $ bIsShooting $
			"} {Armor " $ int(Pawn.ShieldStrength) $
			"} {Adrenaline " $ int(Adrenaline) $
			"} {FloorLocation " $ FloorLocation $
			"} {FloorNormal " $ FloorNormal $
			"}";
			myConnection.sendLine(outstring);


	} else if( Pawn != none )
	{
		if( Pawn.Weapon != None)
		    bIsShooting = Pawn.Weapon.IsFiring();

		PawnRotation = Pawn.Rotation;
		PawnRotation.Pitch = int(Pawn.ViewPitch) * 65556/255;

		FloorNormal = vect(0,0,0);
		Trace(FloorLocation,FloorNormal,Pawn.Location + vect(0,0,-1000),Pawn.Location, false, ,);

		outstring = "SLF {Id " $ myConnection.GetUniqueId(self) $
			"} {Vehicle False" $
			"} {Rotation " $ PawnRotation $
			"} {Location " $ Pawn.Location $
			"} {Velocity " $ Pawn.Velocity $
			"} {Name " $ PlayerReplicationInfo.PlayerName $
			"} {Team " $ TeamIndex $
			"} {Health " $ Pawn.Health $
			"} {Weapon " $ Pawn.Weapon $
			"} {Shooting " $ bIsShooting $
			"} {Armor " $ int(Pawn.ShieldStrength) $
			"} {SmallArmor " $ int(xPawn(Pawn).SmallShieldStrength) $
			"} {Adrenaline " $ int(Adrenaline) $
			"} {Crouched " $ Pawn.bIsCrouched $
			"} {Walking " $ Pawn.bIsWalking $
			"} {FloorLocation " $ FloorLocation $
			"} {FloorNormal " $ FloorNormal $
			"} {Combo " $ xPawn(Pawn).CurrentCombo $
			"} {UDamageTime " $ xPawn(Pawn).UDamageTime $
			"}";


		if( Pawn.Weapon != None)
		{
			outstring = outstring $" {PrimaryAmmo " $ Pawn.Weapon.AmmoAmount(0) $
			"} {SecondaryAmmo " $ Pawn.Weapon.AmmoAmount(1) $"}";


			if( Pawn.Weapon.GetFireMode(1).IsFiring() )
			{
				outstring = outstring $" {AltFiring True}";
			}
			else
			{
				outstring = outstring $" {AltFiring False}";
			}
		}

        //log("Debug: bFire "$bFire$" bAltFire "$bAltFire);

		myConnection.sendLine(outstring);
	}
	else
	{
		log("Pawn is none in CheckSelf() ");
	}


}

function checkVision()
{
	local Pickup Pickup; //Respawned Inventory on the map is now Pickup;
	local Mover M;
	local Controller C;
	local CTFFlag F;
	local NavigationPoint N;
	local xBombFlag B;
	local Vehicle Veh;
//	local vector HitL, HitN;
	local int temp;
	local string outstring, TeamIndex, WeaponClass;
	local bool flagVisible;

	//for PRJ
	local Projectile Proj;
	local vector FireDir;
	local float projDistance;

	if( Pawn == none )
	{
		log("In CheckVision() - Pawn is none ");
		return;
	}

	//!!! view rotation sometimes falls out of synch with rotation? wtf?

	for ( C=Level.ControllerList; C!=None; C=C.NextController )
	{
		if( C != self && C.Pawn != none && CanSee(C.Pawn))//to match peripheral vision
		{

			if(Level.Game.isA('BotTeamGame'))
			{
				TeamIndex = string(C.PlayerReplicationInfo.Team.TeamIndex);
			}
			else
			{
    			TeamIndex = "255";
			}
			if (C.Pawn.Weapon != none)
			{
				WeaponClass = string(C.Pawn.Weapon.Class);
			}
			else
			{
				WeaponClass = "None";
			}
			outstring = "PLR {Id " $ myConnection.GetUniqueId(C) $
				"} {Rotation " $ C.Pawn.Rotation $
				"} {Location " $ C.Pawn.Location $
				"} {Velocity " $ C.Pawn.Velocity $
				"} {Name " $ C.PlayerReplicationInfo.PlayerName $
				"} {Team " $ TeamIndex $
				"} {Reachable " $ actorReachable(C.Pawn) $
				"} {Weapon " $ WeaponClass $
				"}";

			if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(0).IsFiring() )
				outstring = outstring $" {Firing 1}";
			else if((C.Pawn.Weapon != none) && C.Pawn.Weapon.GetFireMode(1).IsFiring() )
				outstring = outstring $" {Firing 2}";
			else
				outstring = outstring $" {Firing 0}";

			myConnection.sendLine(outstring);

        }//end if
	}//end for P=Level.ControllerList

	foreach DynamicActors(class'Pickup',Pickup)
	{
		if( (Pickup.GetStateName() == 'Pickup') && !Pickup.bHidden && inFront(Pickup.Location) && LineOfSightTo(Pickup) )
		{
			myConnection.SendLine("INV {Id " $ myConnection.GetUniqueId(Pickup) $
				"} {Location " $ Pickup.Location $
				"} {Amount " $ myConnection.GetItemAmount(Pickup) $
				"} {Reachable " $ actorReachable(Pickup) $
				"} {Visible True" $ //for compatibility reasons, we know its true due to the check up in if statement
				"} {Dropped " $ Pickup.bDropped $
				"} {Type " $ Pickup.Class $
				"}");

		}
	}

	foreach AllActors(class'Mover',M)
	{
		if( !M.bHidden && inFront(M.Location) && LineOfSightTo(M) )//&& Pawn.FastTrace(M.Location) )
		{
			outstring = "MOV {Id " $ M $
				"} {Location " $ M.Location $
				"} {Reachable " $ actorReachable(M) $ //not sure if this works for lifts(bots may be forced to wait for lift)
				"} {Visible True" $ //for compatibility reasons, we know its true due to the check up in if statement
				"} {DamageTrig " $ M.bDamageTriggered $
				"} {Type " $ M.Class $
				"} {IsMoving " $ M.bInterpolating $
				"} {Velocity " $ M.Velocity $
				"}";

			myConnection.SendLine(outstring);
		}
	}

	foreach DynamicActors(class'Projectile',Proj)
	{

		if (Proj.IsA('FlakChunk'))
			FireDir = Normal(Proj.Velocity);
		else
			FireDir = vector(Proj.Rotation);

		if ( LineOfSightTo(Proj) && inFront(Proj.Location))
		{
			projDistance = VSize(Pawn.Location - Proj.Location);

			myConnection.SendLine("PRJ {Id " $ myConnection.GetUniqueId(Proj) $
				"} {Time " $ (projDistance/Proj.Speed) $
				"} {Direction " $ FireDir $
				"} {Speed " $ Proj.Speed $
				"} {Velocity " $ Proj.Velocity $
				"} {Location " $ Proj.Location $
				"} {Origin " $ Proj.Instigator.Location $
				"} {DamageRadius " $ Proj.DamageRadius $
				"} {Type " $ Proj.Class $
				"}");
		}

	}//end PRJ

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		//Added attribute Visible, so inFront is not here anymore
		if( LineOfSightTo(N))//FastTrace(N.Location) )
		{
			//ControlPoint is now xDomPoint
			if(N.IsA('xDomPoint'))
			{
				if( xDomPoint(N).ControllingTeam == none )
					temp = 255;
				else
					temp = xDomPoint(N).ControllingTeam.TeamIndex;

				myConnection.SendLine("DOM {Id " $ N $
					"} {Visible " $ inFront( N.Location ) $
					"} {Reachable " $ actorReachable(N) $
					"} {Controller " $ temp $
					"}");

			}
			else
			{
				outstring = "NAV {Id " $ N $
					"} {Location " $ N.Location $
					"} {Visible " $ inFront( N.Location ) $
					"} {Reachable " $ actorReachable(N) $
					"}";
			/*	Location returned to all NavPoints for now
			if (N.IsA('LiftCenter'))
   				{
   					outstring = outstring $ " {Location "$ N.Location $"}";
   				}*/
				myConnection.SendLine(outstring);
			}
		}
	}//end for N=Level.NavigationPointList

	//Vehicles support
	//TODO: Is it Possible to get them through: Local pawn p;
	//For (p=level.pawnlist;p!=none;p=p.nextpawn)?
	foreach DynamicActors(Class'Vehicle', Veh) // iterates though all dynamic actors that are 'vehicles'
	{                                                    // and stores a ref to them in  FoundGameInfo
		if (LineOfSightTo(Veh) && inFront(Veh.Location))
		{

		/*	if (string(Veh.Group) == "None")
			{
				//will change the Group variable of the object to unique id
				//myConnection.GetUniqueId(Veh);

				BotDeathMatch(Level.Game).GameBotsID++;
				Veh.SetPropertyText("Group",string(BotDeathMatch(Level.Game).GameBotsID));
			}  */
        	outstring = "VEH {Id " $ myConnection.GetUniqueId(Veh) $
				"} {Location " $ Veh.Location $
				"} {Rotation " $ Veh.Rotation $
				"} {Velocity " $ Veh.Velocity $
				"} {Health " $ Veh.Health $
				"} {Armor " $ int(Veh.ShieldStrength) $
				"} {Driver " $ myConnection.getUniqueId(Veh.Controller) $
				"} {Team " $ Veh.Team $
				"} {TeamLocked " $ Veh.bTeamLocked $
				"} {Type " $ Veh.Class $
				"}";
			myConnection.SendLine(outstring);
			//log(outstring);
		}

	}

	//BombingRun bomb support
	if (Level.Game.IsA('BotBombingRun'))
	{
		//TODO: Move this allActors search to some different place,
		// Not to do it that often.
		foreach AllActors (class'xBombFlag', B)
		{
		    flagVisible = false;

        	outstring = "BOM {Id "  $ B $
				"} {Reachable " $ actorReachable(B) $
				"} {State " $ B.GetStateName() $
				"}";

			//when a bomb is held its location is not updated by engine =(
			if(B.IsInState('Held') && B.Holder != none)
			{
				outstring = outstring $" {HolderTeam " $ B.Holder.Controller.PlayerReplicationInfo.Team.TeamIndex $"}";

				if ( LineOfSightTo(B.Holder) && inFront(B.Holder.Location) )
				{
					outstring = outstring $" {Location " $ B.Holder.Location $
						"} {Holder " $ myConnection.GetUniqueId(B.Holder) $
						"}";
					flagVisible = True;
				}
				else if (B.Holder == Pawn)
				{
					outstring = outstring $" {Holder " $ myConnection.GetUniqueId(B.Holder) $"}";
				}
			}
			else
			{
				if (LineOfSightTo(B) && inFront(B.Location))
				{
					outstring = outstring $ " {Location " $ B.Location $ "}";
					flagVisible = True;
				}
			}

			outstring = outstring $" {Visible " $ flagVisible $"}";

			myConnection.SendLine(outstring);
		}
	}

	//CTF Game support
	if (Level.Game.IsA('BotCTFGame'))
	{
		//TODO: Move this allActors search to some different place,
		// Not to do it that often.
		foreach AllActors (class'CTFFlag', F)
		{
			flagVisible = false;

			outstring = "FLG {Id " $ F $
				"} {Team " $ F.Team.TeamIndex $
				"} {Reachable " $ actorReachable(F) $
				"} {State " $ F.GetStateName() $
				"}";

			//when a flag is held its location is not updated by engine =(
			if(F.IsInState('Held') && F.Holder != none)
			{
				if ( LineOfSightTo(F.Holder) && inFront(F.Holder.Location) )
				{
					outstring = outstring $ " {Location " $ F.Holder.Location $
						"} {Holder " $ myConnection.GetUniqueId(F.Holder) $"}";
					flagVisible = True;
				}
				else if (F.Holder == Pawn)
				{
					outstring = outstring $" {Holder " $ myConnection.GetUniqueId(F.Holder) $"}";
				}
			}
			else
			{
				if (LineOfSightTo(F) && inFront(F.Location))
				{
					outstring = outstring $" {Location " $ F.Location $"}";
					flagVisible = True;
				}
			}

			outstring = outstring $" {Visible " $ flagVisible $"}";

			myConnection.SendLine(outstring);

		}
	}
}


simulated event Destroyed()
{
	local LinkedReplicationInfo PRI;

    //Destroying all linked replication infos - just on clients
    if (ROLE < ROLE_AUTHORITY)
		for (PRI = PlayerReplicationInfo.CustomReplicationInfo; PRI != none; PRI = PRI.NextReplicationInfo)
		{
			PRI.Destroy();
		}


	//Destroying bot Pawn
	DestroyPawn(); //kill him properly first
	if (Pawn != None)
	{
		Pawn.Destroy();//destroy him
		Pawn = None;
    }

	//Destroying actor for aiming our shooting on location
    if (myTarget != none)
    {
		myTarget.Destroy();
	}

	if (myConnection != none)
		myConnection.SendLine("FIN");
	else
		log("Problem with sending FIN, myConnection = none");

    Super.Destroyed();
}

function ChangeWeapon();
state MoveToGoal
{
	function BeginState();
}

function ServerChangedWeapon(Weapon OldWeapon, Weapon NewWeapon);

simulated function Tick(float DeltaTime)
{
							  /*
	local Controller Player;

	Player = Level.GetLocalPlayerController();

	GBxPlayer(Player).GBHUD.DrawLine(Pawn.Location,FocalPoint);
							 */
	super.Tick(DeltaTime);
	if (bShowFocalPoint)
	{
		myConnection.FocusActor.bHidden = false;
		if (Focus != none)
		{
		    myConnection.FocusActor.SetLocation(Focus.Location);
		}
		else
		{
			myConnection.FocusActor.SetLocation(FocalPoint);
		}

	}
	else
		myConnection.FocusActor.bHidden = true;
	//log("In RemoteBot: Tick()");
}

//-----------------

defaultproperties
{
	remoteVisionLimit=0.707000
	SpeedMultiplier=1.0
	bDrawTraceLines=true
	bIncludeFadeOutInMsg=false
	bShowFocalPoint=false
	bPerfectLocationAim=false
	bSpeakingBots=false
	bAutoTrace=false
	bAutoSpawn=true
	MaxSpeed=2.00000
	DesiredSkin="ThunderCrash.JacobM"
}
