/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.ut2004.testbase;

import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.ut2004.server.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.server.exceptions.UCCStartException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;

/**
 * Base class for tests that need a running UCC instance. If you inherit from this class
 * then before the first @Test method will be called the UCC server will be executed.
 * The ports where it is listening can be obtained by <code>ucc.getGbPort()</code>
 * and <code>ucc.getControlPort()</code> calls. Don't forget to specify pogamut.unreal.home and
 * pogamut.unreal.serverexec variables. 
 * @author ik
 */
public class ServerTestBase {

    static protected UCCWrapper ucc = null;

    /**
     * If true then use ucc executed through uccwrapper, othervise use externaly
     * executed instance.
     */
    static protected boolean useInternalUcc = false;

    /**
     * Starts UCC server.
     * @throws cz.cuni.amis.pogamut.ut2004.server.exceptions.UCCStartException
     */
    @BeforeClass
    public static void startUCC() throws UCCStartException {
        if(useInternalUcc) {
        Logger logger = Logger.getAnonymousLogger();
        logger.addHandler(new ConsoleHandler());
        //ucc = new UCCWrapper(logger, "DM-Trainingday");
        }
    }

    /**
     * Kills the UCC server.
     */
    @AfterClass
    public static void endUCC() {
        if(useInternalUcc) {
            ucc.kill();
        }
    }

    /**
     * Returns address of where the bots should connect to.
     * @return
     */
    protected SocketConnectionAddress createAdress() {
        return new SocketConnectionAddress("localhost", useInternalUcc ? ucc.getGbPort() : 3000);
    }
}
