package cz.cuni.amis.pogamut.ut2004.server.commands;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;

public class TestCase02_PlayerControlTest extends ServerTest {

	protected PlayerControl pc;

	public static void main(String[] args) {
		ServerTest test = new TestCase02_PlayerControlTest();
		test.doTest();
	}

	
	protected class ControlPanel extends JPanel {

		protected JButton moveTo, runTo, walkTo, turnTo;
		protected JTextField l1x, l1y, l1z, l2x, l2y, l2z;
		protected JButton control, noControl;

		public ControlPanel() {
			super(new GridLayout(4, 3));
			moveTo = new JButton("Move to");
			runTo = new JButton("Run to");
			walkTo = new JButton("Walk to");
			turnTo = new JButton("Turn to");
			l1x = new JTextField();
			l1y = new JTextField();
			l1z = new JTextField();
			l2x = new JTextField();
			l2y = new JTextField();
			l2z = new JTextField();
			l1x.setSize(20, 20);
			l1y.setSize(20, 20);
			l1z.setSize(20, 20);
			l2x.setSize(20, 20);
			l2y.setSize(20, 20);
			l2z.setSize(20, 20);
			add(l1x);
			add(l1y);
			add(l1z);
			add(l2x);
			add(l2y);
			add(l2z);

			add(runTo);
			add(walkTo);
			add(moveTo);
			add(turnTo);
			runTo.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					pc.runTo("Flavius", new Location(Double.valueOf(l1x
							.getText()), Double.valueOf(l1y.getText()), Double
							.valueOf(l1z.getText())));
				}

			});
			walkTo.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					pc.walkTo("Flavius", new Location(Double.valueOf(l1x
							.getText()), Double.valueOf(l1y.getText()), Double
							.valueOf(l1z.getText())));
				}

			});
			moveTo.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					pc.moveTo("Flavius", new Location(Double.valueOf(l1x
							.getText()), Double.valueOf(l1y.getText()), Double
							.valueOf(l1z.getText())), new Location(Double
							.valueOf(l2x.getText()), Double.valueOf(l2y
							.getText()), Double.valueOf(l2z.getText())), false);
				}

			});
			turnTo.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					pc.turnTo("Flavius", new Location(Double.valueOf(l1x
							.getText()), Double.valueOf(l1y.getText()), Double
							.valueOf(l1z.getText())));
				}

			});
			
			control = new JButton("Switch ON");
			noControl = new JButton("Switch OFF");
			control.setEnabled(false);
			add(control);
			add(noControl);
			control.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					pc.setPlayerControl("Flavius", true);
					control.setEnabled(false);
					noControl.setEnabled(true);					
				}
				
			});
			noControl.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					pc.setPlayerControl("Flavius", false);
					control.setEnabled(true);
					noControl.setEnabled(false);					
				}
				
			});
		}
	}

	public TestCase02_PlayerControlTest() {
		pc = new PlayerControl(server, logger);
	}

	@Override
	public void doTest() {
		JFrame frame = new JFrame("Control panel");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// Create and set up the content pane.
		ControlPanel control = new ControlPanel();
		control.setOpaque(true); // content panes must be opaque
		frame.setContentPane(control);

		// Display the window.
		frame.pack();
		frame.setVisible(true);
	}

}
