/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.ut2004.bot.navigation;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.agent.worldview.IWorldEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTAstar;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;

/**
 * Tests UTAstar and UTPathExecutor.
 * @author ik
 */
public class NavigatingBot extends SyncUT2004Bot {

    UTPathExecutor pathExecutor = null;
    boolean first = true;
    public CountDownLatch targetReached = new CountDownLatch(1);

    @Inject
    public NavigatingBot(AgentLogger logger, UT2004SyncLockableWorldView worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
    }

    @Override
    protected void doLogic() throws PogamutException {
        if (first) {
            // init
            pathExecutor = new UTPathExecutor(getWorldView(), getAct(), new UTAstar(getAct(), getWorldView()));
            pathExecutor.addPathListener(new PathExecutorListener() {

                public void onEvent(PathEventType eventType) {
                    if (eventType.equals(PathEventType.TARGET_REACHED)) {
                        targetReached.countDown();
                    }
                }
            });

    /*        getWorldView().addUpdatedListener(Self.class, new WorldObjectEventListener<Self>() {

                public void notify(Self event) {
                    System.err.println(event);
                }
            });
*/
            // find target navpoint
            Collection<NavPoint> navpoints = getWorldView().getAll(NavPoint.class).values();
            NavPoint np = null;
            for (NavPoint p : navpoints) {
                if (p.getId().getStringId().toUpperCase().equals("DM-TRAININGDAY.INVENTORYSPOT52")) {
                    np = p;
                    break;
                }
            }

            // go to the navpoint
            pathExecutor.goTo(np);
            first = false;
        }

    }

    @Override
    protected void botKilled(BotKilled event) {
    }

    @Override
    protected void prePrepareBot() {
    }

    @Override
    protected void postPrepareBot(GameInfo info) {
    }

    @Override
    protected Initialize createInitializeCommand() {
        return new Initialize("NavTestBot", 1, false, false, new Location(1100, 360, -80), null, null, 1, false, false, null);
    }

    @Override
    protected void botInitialized(ConfigChange config, InitedMessage init) {
    }
}
