package cz.cuni.amis.pogamut.ut2004.bot;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;

@AgentScoped
public class MindlessSyncBot extends SyncUT2004Bot<UT2004SyncLockableWorldView>{

	@Inject
	public MindlessSyncBot(AgentLogger logger, UT2004SyncLockableWorldView worldView, ICommandSerializer commandSerializer) {
		super(logger, worldView, commandSerializer);
	}

	@Override
	protected void prePrepareBot() {
	}
	
	@Override
	protected void postPrepareBot(GameInfo info) {
	}
	
	@Override
	protected Initialize createInitializeCommand() {
		return new Initialize().setName("MindlessSyncBot");
	}
	
	@Override
	protected void botInitialized(ConfigChange config, InitedMessage init) {
	}

	@Override
	protected void doLogic() throws PogamutException {
		getAct().act(new TurnTo().setRotation(new Rotation(50,50,50)));
	}

	@Override
	protected void botKilled(BotKilled event) {
	}

}
