/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.ut2004.test;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldObjectEventListener;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.connection.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.factory.guice.UT2004BotModule;
import java.util.logging.Level;

/**
 *
 * @author ik
 */
@AgentScoped
public class Bot extends SyncUT2004Bot {

    WorldEventListener l = null;
    AgentInfo agentInfo = null;

    @Inject
    public Bot(AgentLogger logger, UT2004SyncLockableWorldView worldView, ICommandSerializer commandSerializer) {
        super(logger, worldView, commandSerializer);
    }

    @Override
    protected void doLogic() throws PogamutException {
    }

    @Override
    protected void botKilled(BotKilled event) {
    }

    @Override
    protected void prePrepareBot() {

        getWorldView().addListener(WorldObjectUpdatedEvent.class, l = new WorldEventListener<WorldObjectUpdatedEvent<Self>>() {

            public void notify(WorldObjectUpdatedEvent<Self> event) {
                if (event.getObject() instanceof Self) {
                    log(Level.INFO, "slf");
                }
            }
        });

        getWorldView().addUpdatedListener(Self.class, new WorldObjectEventListener<Self>() {

            public void notify(Self event) {
                log(Level.INFO, "slf");
            }
        });


        getWorldView().addAppearedListener(Player.class, new WorldObjectEventListener<Player>() {

            public void notify(Player event) {
                log(Level.INFO, "plr");
            }
        });

        getWorldView().addDisappearedListener(Player.class, new WorldObjectEventListener<Player>() {

            public void notify(Player event) {
                log(Level.INFO, "plr");
            }
        });

        getWorldView().addUpdatedListener(Player.class, new WorldObjectEventListener<Player>() {

            public void notify(Player event) {
                log(Level.INFO, "plr");
            }
        });

        getWorldView().addListener(WorldObjectFirstEncounteredEvent.class, l = new WorldEventListener<WorldObjectFirstEncounteredEvent<Player>>() {

            public void notify(WorldObjectFirstEncounteredEvent<Player> event) {
                if (event.getObject() instanceof Player) {
                    log(Level.INFO, "slf");
                }
            }
        });

        getWorldView().addListener(WorldObjectDestroyedEvent.class, l = new WorldEventListener<WorldObjectDestroyedEvent<Player>>() {

            public void notify(WorldObjectDestroyedEvent<Player> event) {
                if (event.getObject() instanceof Player) {
                    log(Level.INFO, "slf");
                }
            }
        });
    }

    @Override
    protected void postPrepareBot(GameInfo info) {
        /*  for (NavPoint p : getWorldView().getAll(NavPoint.class).values()) {
        if (p.getId().getUnrealId().toUpperCase().equals(Pogamut.getPlatform().getProperty("start.loc.id").toUpperCase())) {

        getAct().act(new Respawn(agentInfo.getId(), p.getLocation(), new Rotation()));
        }
        }
         * */
    }

    @Override
    protected Initialize createInitializeCommand() {
        return new Initialize();
    }

    @Override
    protected void botInitialized(ConfigChange config, InitedMessage init) {
    }

    public static void main(String args[]) throws PogamutException {
        IAgentFactory<ISocketConnectionAddress> factory = new GuiceAgentFactory(new UT2004BotModule() {

            @Override
            protected void configure() {
                super.configure();
                bind(IWorldView.class).to(UT2004SyncLockableWorldView.class);
                bind(IAgent.class).to(Bot.class);
            }
        });
        IAgent agent = factory.newAgent(new SocketConnectionAddress("localhost", 3000));
        agent.getLogger().addConsoleHandlersToAllCategories();
        agent.getLogger().setLevel(Level.ALL);
        agent.start();
    }
}
