package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.util.Map;

/**
 * Callback interface for something that intitiates a dialog
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public interface IDialogListener {
	
	public enum State {
		NONE,
		CANCELLED,
		COMMAND_SENT,
		SUBMITTED		
	}
	
	/**
	 * Called when user cancels the dialog
	 * 
	 * @param data
	 *            Data that user filled into the dialog
	 */
	public void dialogCancelled(Dialog dialog, Map<String, String> data);

	/**
	 * Called when user triggers some other action on the dialog
	 * 
	 * @param data
	 *            Data that user filled into the dialog
	 * @return
	 * 		True if the dialog should disappear, false otherwise 
	 */
	public void dialogCommand(Dialog dialog, String command, Map<String, String> data);

	/**
	 * Called when user submits the dialog
	 * 
	 * @param data
	 *            Data that user filled into the dialog
	 */
	public void dialogSubmitted(Dialog dialog, Map<String, String> data);
}
