package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * Framed component that can nest more other components. This is used also as
 * the ground component for dialog, so some panel should be always in the dialog
 * (see setMainPanel method in Dialog class). This creates DialogItem type=PANEL
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class DialogPanel extends DialogFramedComponent {

	protected List<DialogComponent> components = new LinkedList<DialogComponent>();

	public DialogPanel() {
		super();
	}
	
	public DialogPanel(String id) {
		super(id);
	}
	
	/**
	 * Adds a new component to this panel
	 * 
	 * @param component
	 */
	public void addComponent(DialogComponent component) {
		components.add(component);
		component.setParent(this);
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new LinkedList<DialogItem>();
		list.add(myItemCommand());
		for (DialogComponent component : components) {
			list.addAll(component.createItemCommands());
		}
		return list;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("PANEL");
		return myItem;
	}

	@Override
	public DialogComponent findComponent(String id) {
		DialogComponent dc = super.findComponent(id);
		if (dc != null) {
			return dc;
		}
		for (DialogComponent c: components) {
			dc = c.findComponent(id);
			if (dc != null) {
				return dc;
			}
		}
		return null;
	}

}
