package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * This can be either radiobutton or checkbox, as you need - the behaviour
 * depends on parent DialogOptionList's mode, but the lookout you can set here
 * (so each option can look differently, although it's not recommended)
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class DialogOption extends DialogComponent {
	/** Texture of the checked button */
	protected String checked;
	/** Texture of the not checked button */
	protected String notChecked;
	/** Text displayed on the option */
	protected String text;
	/** Color of the text */
	protected Color textColor;

	public DialogOption() {
		super();
	}
	
	public DialogOption(String id) {
		super(id);
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new LinkedList<DialogItem>();
		list.add(myItemCommand());
		return list;
	}

	public String getChecked() {
		return checked;
	}

	public String getNotChecked() {
		return notChecked;
	}

	public String getText() {
		return text;
	}

	public Color getTextColor() {
		return textColor;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("OPTION");
		myItem.setText(text);
		myItem.setTextColor(textColor);
		myItem.setChecked(checked);
		myItem.setNotChecked(notChecked);
		return myItem;
	}

	public void setChecked(String checked) {
		this.checked = checked;
	}

	public void setNotChecked(String notChecked) {
		this.notChecked = notChecked;
	}

	public void setText(String text) {
		this.text = text;
	}

	public void setTextColor(Color textColor) {
		this.textColor = textColor;
	}

}
