package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

public class DialogImage extends DialogComponent implements IHasAction {

	protected String action;
	protected String image;
	protected List<IDialogListener> listeners = new LinkedList<IDialogListener>();
	protected Point2D origin;

	protected Dimension2D scale;

	public DialogImage() {
		super();
	}

	public DialogImage(String id) {
		super(id);
	}

	@Override
	public void addListener(IDialogListener listener) {
		listeners.add(listener);
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new LinkedList<DialogItem>();
		list.add(myItemCommand());
		return list;
	}

	@Override
	public void dialogCancelled(Dialog dialog, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogCancelled(dialog, data);
		}
	}

	@Override
	public void dialogCommand(Dialog dialog, String command, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogCommand(dialog, command, data);
		}
	}

	@Override
	public void dialogSubmitted(Dialog dialog, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogSubmitted(dialog, data);
		}
	}

	public String getAction() {
		return action;
	}

	public String getImage() {
		return image;
	}

	public Point2D getOrigin() {
		return origin;
	}

	public Dimension2D getScale() {
		return scale;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("IMAGE");
		myItem.setImage(image);
		myItem.setOrigin(origin);
		myItem.setScale(scale);
		myItem.setAction(action);
		return myItem;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public void setOrigin(Point2D origin) {
		this.origin = origin;
	}

	public void setScale(Dimension2D scale) {
		this.scale = scale;
	}
}
