package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.Color;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * Base of those components which have background and border (nontransparent).
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 *
 */
public abstract class DialogFramedComponent extends DialogComponent {
	/** color of background **/
	protected Color bgColor;
	/** texture of background */
	protected String background;
	/** color of border */
	protected Color border;
	
	public DialogFramedComponent() {
		super();
	}
	
	public DialogFramedComponent(String id) {
		super(id);		
	}
	
	public Color getBgColor() {
		return bgColor;
	}

	public void setBgColor(Color bgColor) {
		this.bgColor = bgColor;
	}

	public String getBackground() {
		return background;
	}

	public void setBackground(String background) {
		this.background = background;
	}

	public Color getBorder() {
		return border;
	}

	public void setBorder(Color border) {
		this.border = border;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setBackground(background);
		myItem.setBgColor(bgColor);
		myItem.setBorder(border);
		return myItem;
	}

}
