package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * Base of all dialog's components
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public abstract class DialogComponent {
	private static int componentCount = 0;
	private String id;
	protected Dimension2D size;
	protected Point2D position;
	protected DialogComponent parent;

	public DialogComponent() {
		id = "dc" + Integer.toString(++componentCount);
	}

	public DialogComponent(String id) {
		this.id = id;
	}

	/**
	 * Creates a list of DialogItem
	 * 
	 * @return
	 */
	public abstract List<DialogItem> createItemCommands();

	/**
	 * Creates a DialogItem command belonging to this component
	 * 
	 * @return
	 */
	protected DialogItem myItemCommand() {
		DialogItem myItem = new DialogItem();
		myItem.setId(id);
		myItem.setSize(size);
		myItem.setPosition(position);
		if (parent != null) {
			myItem.setParent(parent.getId());
		}
		return myItem;
	}

	/**
	 * Tries to find in children components a component with specified id
	 * 
	 * @param id
	 * @return
	 */
	public DialogComponent findComponent(String id) {
		if (id.equals(this.id)) {
			return this;
		}
		return null;
	}

	public Dimension2D getSize() {
		return size;
	}

	public void setSize(Dimension2D size) {
		this.size = size;
	}

	public Point2D getPosition() {
		return position;
	}

	public void setPosition(Point2D position) {
		this.position = position;
	}

	public String getId() {
		return id;
	}

	public DialogComponent getParent() {
		return parent;
	}

	public void setParent(DialogComponent parent) {
		this.parent = parent;
	}

}
