package cz.cuni.amis.pogamut.ut2004.server.commands.dialog;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DialogItem;

/**
 * Class describing the button on dialog.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class DialogButton extends DialogFramedComponent implements IHasAction {

	/** Action performed when the button is pressed */
	protected String action;
	protected List<IDialogListener> listeners = new LinkedList<IDialogListener>();
	/** Text written on the button */
	protected String text;

	/** Color of the text */
	protected Color textColor;

	public DialogButton() {
		super();
	}

	public DialogButton(String id) {
		super(id);
	}

	@Override
	public void addListener(IDialogListener listener) {
		listeners.add(listener);
	}

	@Override
	public List<DialogItem> createItemCommands() {
		List<DialogItem> list = new LinkedList<DialogItem>();
		list.add(myItemCommand());
		return list;
	}

	@Override
	public void dialogCancelled(Dialog dialog, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogCancelled(dialog, data);
		}
	}

	@Override
	public void dialogCommand(Dialog dialog, String command, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogCommand(dialog, command, data);
		}
	}

	@Override
	public void dialogSubmitted(Dialog dialog, Map<String, String> data) {
		for (IDialogListener c : listeners) {
			c.dialogSubmitted(dialog, data);
		}
	}

	public String getAction() {
		return action;
	}

	public String getText() {
		return text;
	}

	public Color getTextColor() {
		return textColor;
	}

	@Override
	protected DialogItem myItemCommand() {
		DialogItem myItem = super.myItemCommand();
		myItem.setType("BUTTON");
		myItem.setAction(action);
		myItem.setText(text);
		myItem.setTextColor(textColor);
		return myItem;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public void setText(String text) {
		this.text = text;
	}

	public void setTextColor(Color textColor) {
		this.textColor = textColor;
	}

}
