package cz.cuni.amis.pogamut.ut2004.server.commands;

import java.util.logging.Logger;

import cz.cuni.amis.pogamut.base3d.worldview.objects.Location;
import cz.cuni.amis.pogamut.base3d.worldview.objects.Rotation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.CommandPlayer;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetPlayerControl;
import cz.cuni.amis.pogamut.ut2004.server.AbstractUT2004Server;

/**
 * This class encapsulates control of players' movement from server.
 * 
 * @author Radim Vansa <radim.vansa@matfyz.cz>
 * 
 */
public class PlayerControl extends ServerCommands {

	public PlayerControl(AbstractUT2004Server server, Logger log) {
		super(server, log);
	}

	/**
	 * Moves player to specified location, while looking to specified place
	 * 
	 * @param playerName
	 * @param whereToGo
	 * @param whereToLook
	 * @param shouldWalk
	 */
	public void moveTo(String playerName, Location whereToGo,
			Location whereToLook, boolean shouldWalk) {
		CommandPlayer commandPlayer = new CommandPlayer();
		commandPlayer.setPlayer(playerName);
		commandPlayer.setCommand("MOVE");
		commandPlayer.setLocation(whereToGo);
		commandPlayer.setFocusLocation(whereToLook);
		commandPlayer.setWalk(shouldWalk);
		server.getAct().act(commandPlayer);
	}

	/**
	 * Turns player to specified location and lets him run there (on straight
	 * line).
	 * 
	 * @param playerName
	 * @param location
	 * @param shouldWalk
	 */
	public void runTo(String playerName, Location location) {
		CommandPlayer commandPlayer = new CommandPlayer();
		commandPlayer.setPlayer(playerName);
		commandPlayer.setCommand("MOVE");
		commandPlayer.setLocation(location);
		commandPlayer.setFocusLocation(location);
		commandPlayer.setWalk(false);
		server.getAct().act(commandPlayer);
	}

	/**
	 * Removes or returns control to player.
	 * 
	 * @param playerName
	 * @param control
	 */
	public void setPlayerControl(String playerName, boolean control) {
		SetPlayerControl setPlayerControl = new SetPlayerControl();
		setPlayerControl.setPlayer(playerName);
		setPlayerControl.setControl(control);
		server.getAct().act(setPlayerControl);
	}

	/**
	 * Turns player towards specified location
	 * @param playerName
	 * @param location
	 */
	public void turnTo(String playerName, Location location) {
		CommandPlayer commandPlayer = new CommandPlayer();
		commandPlayer.setPlayer(playerName);
		commandPlayer.setCommand("TURNTO");
		commandPlayer.setLocation(location);
		server.getAct().act(commandPlayer);
	}
	
	/**
	 * Turns player according to specified direction
	 * 
	 * @param playerName
	 * @param rotation
	 *            Direction of sight
	 */
	public void turnTo(String playerName, Rotation rotation) {
		CommandPlayer commandPlayer = new CommandPlayer();
		commandPlayer.setPlayer(playerName);
		commandPlayer.setCommand("TURNTO");
		commandPlayer.setRotation(rotation);
		server.getAct().act(commandPlayer);
	}
	
	/**
	 * Turns player to specified location and lets him walk there (on straight
	 * line).
	 * 
	 * @param playerName
	 * @param location
	 * @param shouldWalk
	 */
	public void walkTo(String playerName, Location location) {
		CommandPlayer commandPlayer = new CommandPlayer();
		commandPlayer.setPlayer(playerName);
		commandPlayer.setCommand("MOVE");
		commandPlayer.setLocation(location);
		commandPlayer.setFocusLocation(location);
		commandPlayer.setWalk(true);
		server.getAct().act(commandPlayer);
	}
}
