package cz.cuni.amis.pogamut.ut2004.server;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.server.WorldAgentsObserver;
import cz.cuni.amis.pogamut.base.server.WorldServer;
import cz.cuni.amis.pogamut.ut2004.bot.AbstractUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.server.exceptions.MapChangeException;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.Collection;
import java.util.List;

// TODO: [Ruda] specify the UT2004 server interface
public interface IUT2004Server extends WorldServer<IAgent> {
    /**
     * 
     * @return List of all maps available on the UT server
     */
    Collection<MapList> getAvailableMaps();
  
// GameInfo doesn't exist anymore, JSimlo changed it into something else
//    public GameInfo getGameInfo();
    
    /**
     * The flag raises events even when the game speed was changed by another 
     * UTServer instance or directly in game.
     * @return Speed of the game.
     */
    public Flag<Double> getGameSpeedFlag();
    
    /** 
     * 
     * @return Flag with name of the current map.
     */
    public ImmutableFlag<String> getMapFlag();
    
    /**
     * Blocking method for changing server's map
     * @param map
     */
    public void setGameMap(String map) throws MapChangeException;
    
    /**
     * Returns list of all players connected to the game server. The difference 
     * compared to the getAgents() method is that this method can return even the
     * native bots, human players etc. 
     * @return List of all players on the server.
     */
    public ObservableCollection<Player> getPlayers();
    
    /**
     * Reeturns list of all mutators available on the server. Mutators can be 
     * used to modify the game (eg. disable weapons, change game speed).
     * @return List of all mutators available on the server.
     */
    List<Mutator> getMutators();

    /**
     * Connects a UT native bot to the current map.
     * @param botName
     */
    void connectNativeBot(String botName);

}