package cz.cuni.amis.pogamut.ut2004.factory.guice;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.connection.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;

/**
 * Factory for fast agent instantiation. Provide the agent class eg. MyAgent.class
 * and teh rest of communication chain will be instantiated in the default way.
 * @author ik
 */
public class UTGuiceSyncFactory<SocketConnectionAdress extends ISocketConnectionAddress> extends GuiceAgentFactory<SocketConnectionAddress> {

    public UTGuiceSyncFactory(final Class<? extends SyncUT2004Bot> syncAgentClass) {
        super(new UT2004BotModule() {

            @Override
            protected void configure() {
                super.configure();
                bind(IAgent.class).to(syncAgentClass);
                bind(IWorldView.class).to(UT2004SyncLockableWorldView.class);
            }

        });
    }
}
