package cz.cuni.amis.pogamut.ut2004.factory.guice;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.worldview.EventDrivenWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.DefaultUT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.communication.translator.ServerFSM;
import cz.cuni.amis.pogamut.ut2004.server.UT2004Server;

/**
 * New binding (and no more need to be specified):
 * <p><p>
 * <ol>
 * <li>IWorldMessageHandler -> ServerFSM ... implements GameBots2004 protocol</li>
 * <li>IAgent.class -> UT2004Server ... handles server connection stuff</li>
 * <li>IStartableWorldView -> EventDrivenWorldView</li>
 * </ol>
 *  
 * 
 * @author Jimmy
 */
public class UT2004ServerModule extends UT2004CommunicationModule {

	@Override
	protected void configure() {
		super.configure();
		bind(IWorldMessageTranslator.class).to(ServerFSM.class);
		bind(IStartableWorldView.class).to(DefaultUT2004WorldView.class);
		bind(IAgent.class).to(UT2004Server.class);
	}

}
