package cz.cuni.amis.pogamut.ut2004.factory.guice;

import cz.cuni.amis.pogamut.base.communication.parser.IWorldMessageParser;
import cz.cuni.amis.pogamut.base.communication.parser.IYylex;
import cz.cuni.amis.pogamut.base.factory.guice.PogamutAgentModule;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.IUT2004Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.UT2004Parser;

/**
 * The UT2004CommunicationModule just adds those bindings:
 * <ol>
 * <li>IWorldMessageParser -> UT2004Parser</li>
 * <li>IYylex -> IUT2004Yylex</li>
 * <li>IUT2004Yylex -> Yylex</li>
 * What's left is to define:
 * <ol>
 * <li>IAgent.class</li>
 * <li>IWorldView.class</li>
 * <li>IWorldMessageHandler.class</li>
 * </ol>
 * <p><p>
 * Note that this module is used by the parser test.
 * 
 * @author Jimmy
  */
public class UT2004CommunicationModule extends PogamutAgentModule {
	
	protected void configure() {
		super.configure();
		bind(IYylex.class).to(IUT2004Yylex.class);
		bind(IUT2004Yylex.class).to(Yylex.class);
		bind(IWorldMessageParser.class).to(UT2004Parser.class);
	}

}
