package cz.cuni.amis.pogamut.ut2004.factory.guice;

import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.ut2004.communication.translator.BotFSM;

/**
 * New binding:
 * <p><p>
 * <ol>
 * <li>IWorldMessageHandler -> BotFSM ... implements GameBots2004 protocol</li>
 * </ol>
 * <p><p>
 * Left to be specified:
 * <ol>
 * <li>IAgent.class</li>
 * <li>IStartableWorldView.class</li>
 * </ol> 
 * 
 * @author Jimmy
 */
public class UT2004BotModule extends UT2004CommunicationModule {

	@Override
	protected void configure() {
		super.configure();
		bind(IWorldMessageTranslator.class).to(BotFSM.class);
	}

}
