/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.ut2004.factory.guice;

import cz.cuni.amis.pogamut.base.communication.commands.CommandSerializer;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.communication.connection.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.mediator.Mediator;
import cz.cuni.amis.pogamut.base.communication.parser.IWorldMessageParser;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldEventOutput;
import cz.cuni.amis.pogamut.base.communication.translator.WorldEventOutput;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.DefaultUT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealIdTranslator;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.UT2004Parser;
import cz.cuni.amis.pogamut.ut2004.communication.translator.ServerFSM;
import cz.cuni.amis.pogamut.ut2004.server.UT2004Server;

/**
 * Creates a UT2004Server without use of Guice library.
 * @author ik
 */
public class DefaultUTServerFactory implements IAgentFactory<ISocketConnectionAddress> {

    public UT2004Server newAgent(ISocketConnectionAddress address) throws PogamutException {
        // setup loger
        AgentLogger logger = new AgentLogger();

        // create connection to the world
        SocketConnection socketConnection = new SocketConnection(logger);
        socketConnection.connect(address);

        ///////////////////////////////
        ///      WORLD -> AGENT     ///
        ///////////////////////////////

        // parser for translating text messages into Java objects
        IWorldMessageParser parser = new UT2004Parser(socketConnection, new Yylex(), new UnrealIdTranslator(), logger);

        // translates sets of messages wrapped in Java objects into agregared messages
        IWorldEventOutput producer = new WorldEventOutput(parser, new ServerFSM(logger), logger);

        IMediator mediator = new Mediator(producer, null, logger);
        DefaultUT2004WorldView worldView = new DefaultUT2004WorldView(mediator, logger);

        

        ///////////////////////////////
        ///      AGENT -> WORLD     ///
        ///////////////////////////////

        ICommandSerializer commandSerializer = new CommandSerializer(socketConnection, logger);

        UT2004Server server = new UT2004Server(logger, worldView, commandSerializer);
        return server;
    }
}
