package cz.cuni.amis.pogamut.ut2004.communication.translator.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.FSMTransition;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemListEnd;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemListStart;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.TranslatorContext;
import cz.cuni.amis.pogamut.ut2004.communication.translator.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.communication.translator.server.support.ServerListState;

@FSMState(
			map={
				@FSMTransition(
					state=ServerRunningState.class, 
					symbol={ItemListEnd.class}, 
					transition={}
				)
			}
)
public class ItemListState extends ServerListState<Item, TranslatorContext> {

	public ItemListState() {
		super(ItemListStart.class, Item.class, ItemListEnd.class);
	}
	
	@Override
	public void stateLeaving(TranslatorContext translatorContext,
			IFSMState<InfoMessage, TranslatorContext> toState, InfoMessage symbol) {
		processItems(translatorContext.getNavPoints(), getList(), translatorContext);
		newList();
	}

	private void processItems(Map<UnrealId, NavPoint> origNavPoints, List<Item> list, TranslatorContext context) {
		Map<UnrealId, Item> items = new HashMap<UnrealId, Item>();
		
		for (Item item : list) { 
			items.put(item.getId(), item);
		}
		
		context.setItems(items);
		
		context.processNavPointsAndItems();
		
		if (context.getNavPoints() != null) {
			context.getLogger().fine("Pushing NavPoint events.");
			context.getEventQueue().pushEvent(context.getNavPoints().values().toArray(new IWorldChangeEvent[0]));
		}
		context.getLogger().fine("Pushing Item events.");
		context.getEventQueue().pushEvent(context.getItems().values().toArray(new IWorldChangeEvent[0]));
		
		if (context.getNavPoints() != null) {
			context.getEventQueue().pushEvent(new MapPointListObtained(context.getNavPoints(), context.getItems()));
		}
	}
}