package cz.cuni.amis.pogamut.ut2004.communication.translator.events;

import cz.cuni.amis.pogamut.base.communication.translator.IdentityWrapper;
import java.util.List;

/**
 * Event notifying that list of some objects/events was received.
 * @author ik
 */
public class ListObtained<T> extends IdentityWrapper {

	private List<T> list;

	public ListObtained(List<T> list) {
		this.list = list;
	}

    /**
     * Returns list of received objects.
     * @return
     */
	public List<T> getList() {
		return list;
	}

	public String toString() {
		return "ListObtained[items = " + list.size() + "]";
	}

}
