package cz.cuni.amis.pogamut.ut2004.communication.translator;

import com.google.inject.Inject;

import cz.cuni.amis.fsm.FSM;
import cz.cuni.amis.pogamut.base.communication.exceptions.TranslatorException;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.communication.translator.server.HelloControlServerExpectedState;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTranslator;

public class ServerFSM implements IWorldMessageTranslator {
	
	private IWorldEventQueue eventQueue = new IWorldEventQueue.Queue();
	
	private TranslatorContext context = null;
	
	private FSM<InfoMessage, TranslatorContext> fsm = null;
	
	@Inject
	public ServerFSM(AgentLogger logger) {
		context = new TranslatorContext(eventQueue, ItemTranslator.getInstance(), logger.platform());
		fsm = new FSM<InfoMessage, TranslatorContext>(context, HelloControlServerExpectedState.class, logger.platform());
	}

	@Override
	public IWorldChangeEvent[] processMessage(InfoMessage message) throws TranslatorException {
		fsm.push(context, message);
		return eventQueue.popEvents();
	}

}