package cz.cuni.amis.pogamut.ut2004.communication.translator;

import com.google.inject.Inject;

import cz.cuni.amis.fsm.FSM;
import cz.cuni.amis.pogamut.base.communication.exceptions.TranslatorException;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.communication.translator.bot.HelloBotExpectedState;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTranslator;

/**
 * BotFSM is wrapper for the FSM instance that uses states from cz.cuni.amis.pogamut.ut2004.communication.translator.bot package.
 * 
 * @author Jimmy
 */
public class BotFSM implements IWorldMessageTranslator {
	
	private IWorldEventQueue eventQueue = new IWorldEventQueue.Queue();
	
	private TranslatorContext context = null;
	
	private FSM<InfoMessage, TranslatorContext> fsm = null;
	
	@Inject
	public BotFSM(AgentLogger logger) {
		context = new TranslatorContext(eventQueue, ItemTranslator.getInstance(), logger.platform());
		fsm = new FSM<InfoMessage, TranslatorContext>(context, HelloBotExpectedState.class, logger.platform());
	}

	@Override
	public IWorldChangeEvent[] processMessage(InfoMessage message) throws TranslatorException {
		fsm.push(context, message);
		return eventQueue.popEvents();
	}

}