package cz.cuni.amis.pogamut.ut2004.communication.parser;


import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.communication.connection.IWorldReaderProvider;
import cz.cuni.amis.pogamut.base.communication.exceptions.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.parser.Parser;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealIdTranslator;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.ItemTranslator;

@AgentScoped
public class UT2004Parser extends Parser {
	
	@Inject
	public UT2004Parser(IWorldReaderProvider readerProvider, IUT2004Yylex yylex,
						UnrealIdTranslator unrealIdTranslator, AgentLogger logger
					   )
						throws CommunicationException {
		super(readerProvider, yylex, logger);
		yylex.setTranslator(unrealIdTranslator);
		yylex.setItemTranslator(ItemTranslator.getInstance());
	}
	
//	@Override
//	public InfoMessage parse() throws ParserException {
//		getLogger().user().warning("going to parse message");
//		InfoMessage msg = super.parse();
//		getLogger().user().warning("Message: " + msg);
//		return msg;
//	}
	 

}
