package cz.cuni.amis.pogamut.ut2004.communication.itemtranslator;

import java.util.HashMap;
import java.util.Iterator;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemCategory;

/**
 * Main class responsible for the item decoration.
 * 
 * Items in UT2004 has a lots of characteristics which don't change over the time (at least during one game).
 * As it is pointless to send all those information every time an item is perceived by a bot, those information 
 * are sent through the ITCMsgs. This message is used in ItemTranslator as a configuration message for an ItemDescriptor.
 * 
 * ItemDescriptor contains all characteristics available for the corresponding UTClass of items and is returned by the 
 * ItemTranslator. This description is then attached to the item (in fact to all item events like AIN, INV, IPK).
 * 
 * Now how does it work insight? ItemTranslator uses a set of DescriptorFactories (one for each type of an item).
 * ITCMsg messages are usually sent at the beginning of the game (for all known item categories). 
 * But they can arrive in the middle of the game for a new category of an item.
 * 
 * TODO: maybe it is rather ItemDecorator.
 * 
 * @author Ondrej
 */
public class ItemTranslator {
    
    private HashMap<String, ItemDescriptor> descriptors = new HashMap<String, ItemDescriptor>();

    private String[] availableDescriptors = new String[0];

	private static ItemTranslator instance = new ItemTranslator();
	
    private ItemTranslator() {};
   
    public static ItemTranslator getInstance() {
    	return instance ;
    }
    
	public String[] getItemClasses() {
		if (availableDescriptors.length < descriptors.keySet().size()) {
			String[] availableDescriptors = new String[descriptors.keySet().size()];
			Iterator<String> iterate = descriptors.keySet().iterator();
			int i = 0;
			while (iterate.hasNext()) {
				availableDescriptors[i++] = iterate.next();
			}
		}
		return availableDescriptors;
	}

    public ItemDescriptor getDescriptor(ItemClassable msg) {
		return descriptors.get(msg.getItemClass());
    }
    
    public void createDescriptor(ITCMsg message) {
    	if (message.getItemClass().equals("Weapon")) // will be substituted with the item type - as an enum -> switch
    		descriptors.put(message.getItemClass(), WeaponDescriptorFactory.getInstance().getNewDescriptor(message));
        // if (message.getItemType().equals("Ammo"))...
    	// log. unknown type?
    	descriptors.put(message.getItemClass(), GeneralDescriptorFactory.getInstance().getNewDescriptor(message));
    	
   }
    
   public static void main(String []args) {
	  ItemTranslator translator = ItemTranslator.getInstance();
	  ITCMsg message = new ITCMsg(true);
	  translator.createDescriptor(message);
	  ItemDescriptor descriptor = translator.getDescriptor(message);
	  System.out.println("Descriptor for:" + message.getItemClass() + ": " + descriptor.toString());
   }

	public void createDescriptor(ItemCategory symbol) {
		// TODO WE NEED TO USE THIS METHOD INSTEAD OF METHOD THAT TAKES ITCMsg. We will be receiving this ItemCategory messages.
		
		
	}
	
}