package cz.cuni.amis.pogamut.ut2004.communication.itemtranslator;

import java.util.HashMap;

/**
 * a mock implementation of the ITCMsg
 * 
 * @author Ondrej
 */
public class ITCMsg implements ItemClassable{
	
	private HashMap<String, Object> properties;
	
	private String itemClass = "Weapon";
	
	public ITCMsg() {
		properties = new HashMap<String, Object> ();
	}
	
	public Object get(String key) {
		return properties.get(key);
	}
	
	public boolean contains(String key) {
		return properties.containsKey(key);
	}
	
	public void put(String key, Object attribute) {
		properties.put(key, attribute);
	}
	
	public ITCMsg(boolean mock) {
		properties = new HashMap<String, Object> ();
		if (mock) {
			properties.put("amount", 5);
			properties.put("ammoType", "blabla");
			properties.put("tossed", true);
			properties.put("initialAmmo", 30);
			properties.put("name", "super ultra cool weapon");			
		}
	}

	@Override
	public String getItemClass() {
		return itemClass;
	}

	public HashMap<String, Object> getProperties() {
		return properties;
	}

	
}