package cz.cuni.amis.pogamut.ut2004.bot.commands;

import cz.cuni.amis.pogamut.ut2004.bot.AbstractUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.*;

import java.util.logging.Logger;

/**
 * Class providing Pogamut2 UT2004 simple shooting commands for the bot
 *
 * @author Michal 'Knight' Bida
 */
public class SimpleShooting extends BotCommands
{
    
        /** 
         * Bot will start shooting his current weapon (Issues GB SHOOT command) 
         * 
         * @see stopShoot()
         * @see shoot(UnrealId)
         */
        public void shoot()
        {            
            agent.getAct().act(new Shoot());
        }
        
        /** 
         * Bot will start shooting with his current weapon at the target provided. 
         * (Issues GB SHOOT command) 
         * Note that the bot will track the target while shooting. If not interrupted
         * by other command that will change bot target or that will change bot focus too much. 
         * 
         * @param target Target (that should be ILocated) the bot will shoot at. Bot will track the target, but see note above.
         * 
         * @see stopShoot()
         * @see shoot()
         */
        public void shoot(UnrealId target)
        {   
            
            agent.getAct().act(new Shoot());
        }        
        
        /** 
         * Bot will stop shooting his current weapon (Issues GB STOPSHOOT command) 
         * 
         * @see shoot()
         * @see shoot(UnrealId)
         */
        public void stopShoot()
        {            
            agent.getAct().act(new StopShooting());
        }        
        
	/**
	 * Constructor. Setups the command module based on given agent and logger.
	 * @param agent AbstractUT2004Bot we will send commands for
	 * @param log Logger to be used for logging runtime/debug info.
	 */        
        public SimpleShooting(AbstractUT2004Bot agent, Logger log)
	{
		super(agent, log);                
	}
        
}