package cz.cuni.amis.pogamut.ut2004.bot.commands;

import cz.cuni.amis.pogamut.ut2004.bot.AbstractUT2004Bot;
import cz.cuni.amis.pogamut.base3d.worldview.objects.ILocated;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.*;

import java.util.logging.Logger;

/**
 * Class providing Pogamut2 UT2004 simple locomotion commands for the bot - basic
 * movement and turning.
 *
 * @author Michal 'Knight' Bida
 */
public class SimpleLocomotion extends BotCommands
{
    

        
        /** 
         * Bot will move to supplied location. 
         * (issues GB RUNTO command) 
         * 
         * @param locatedTarget Object with location. We will move to this location.
         * 
         * @see stopMovement()
         */
        public void moveTo(ILocated location)
        {
        	Move move = new Move().setFirstLocation(location.getLocation());
            agent.getAct().act(move);
        }        
        
        /**
         * Makes the bot to stop all movement or turning. (Does not stop shooting.)
         * 
         * (issues GB STOP command) 
         * 
         * @see moveTo(ILocated)
         */
        public void stopMovement()
        {        
            agent.getAct().act(new Stop());        
        }
        
        /** 
         * Bot will turn to face supported location (issues GB TURNTO command) 
         * 
         * @param location Location we will face. 
         * 
         * @see turnHorizontal(int)
         * @see turnVertical(int)         
         */
        public void turnTo(ILocated location)
        {
            TurnTo turnTo = new TurnTo();
            turnTo.setLocation(location.getLocation());
            agent.getAct().act(turnTo);
        }
        
        
         /** 
         * Rotates the bot by the supported amount (in degrees) in left/right direction 
         * (issues GB ROTATE command) 
         * 
         * @param amount Amount of rotation in degrees.
         *
         * @see turnVertical(int)
         * @see turnTo(ILocated)
         */
        public void turnHorizontal(int amount)
        {
            Rotate rotate = new Rotate();
            //full rotation in UT units is 65535
            rotate.setAmount(amount * 65535 / 360);
            agent.getAct().act(rotate);
        }
        
        /** 
         * Rotates the bot by the supported amount (in degrees) in up/down direction 
         * (issues GB ROTATE command) 
         * 
         * @param amount Amount of rotation in degrees.
         *
         * @see turnHorizontal(int)
         * @see turnTo(ILocated)
         */
        public void turnVertical(int amount)
        {
            Rotate rotate = new Rotate();
            //full rotation in UT units is 65535
            rotate.setAmount(amount * 65535 / 360);
            rotate.setAxis("Vertical");
            agent.getAct().act(rotate);
        }
        
        /** 
         * Bot will make simple jump (Issues GB JUMP command) 
         */
        public void jump()
        {            
            agent.getAct().act(new Jump());
        }
        
        /**
         * Sets the walking speed for the bot movement commands. (issues GB SETWALK command)
         * 
         * @see setRun() 
         */
        public void setWalk()
        {
            agent.getAct().act(new SetWalk(true));
        }

        /**
         * Sets the running speed for the bot movement commands. (issues GB SETWALK command)
         * 
         * @see setWalk() 
         */
        public void setRun()
        {
            agent.getAct().act(new SetWalk(false));
        }
        
	/**
	 * Constructor. Setups the command module based on given agent and logger.
	 * @param agent AbstractUT2004Bot we will send commands for
	 * @param log Logger to be used for logging runtime/debug info.
	 */         
        public SimpleLocomotion(AbstractUT2004Bot agent, Logger log)
	{
		super(agent, log);                
	}
        
}