package cz.cuni.amis.pogamut.ut2004.bot.commands;

import cz.cuni.amis.pogamut.ut2004.bot.AbstractUT2004Bot;

import java.util.logging.Logger;

/**
 * Basic abstract class that is the ancestor of classes that provide wrapped UT2004 bot 
 * commands.
 *
 * @author Michal 'Knight' Bida
 */
public abstract class BotCommands
{
        /** The agent we will send commands for */
        public AbstractUT2004Bot agent;
    
    	/** Logger */
	protected Logger log;
        
	/**
	 * Constructor. Setups the command module based on given agent and logger.
	 * @param agent AbstractUT2004Bot we will send commands for
	 * @param log Logger to be used for logging runtime/debug info.
	 */         
        protected  BotCommands(AbstractUT2004Bot agent, Logger log)
	{
                // save the agent
                this.agent = agent;
		// save the logger
		this.log = log;
	}
    	
}