package cz.cuni.amis.pogamut.ut2004.bot;

import cz.cuni.amis.pogamut.base.agent.worldview.IStartableWorldView;
import cz.cuni.amis.pogamut.base.communication.commands.ICommandSerializer;
import cz.cuni.amis.pogamut.base.exceptions.PogamutException;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;

public abstract class AsyncUT2004Bot<WORLD_VIEW extends IStartableWorldView> extends ThreadedUT2004Bot<WORLD_VIEW> {

	public AsyncUT2004Bot(AgentLogger logger, WORLD_VIEW worldView, ICommandSerializer commandSerializer) {
		super(logger, worldView, commandSerializer);
	}
	
	@Override
	protected void doBotLogic() throws PogamutException {
		doLogic();
	}
	
	/**
	 * To be used by the bot developer.
	 * <p><p>
	 * Here you should implement your logic.
	 */
	protected abstract void doLogic() throws PogamutException;

}
