
package cz.cuni.amis.pogamut.ut2004.agent.worldview;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.worldview.BatchAwareWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.objects.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.factory.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.objects.IViewable;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.objects.IGBViewable;
import cz.cuni.amis.pogamut.ut2004.agent.worldview.objects.IGBWorldObjectDisappeared;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;

/**
 * WorldView understanding some UT2004 semantics.
 * @author ik
 */
public class DefaultUT2004WorldView extends BatchAwareWorldView {
    @Inject
    public DefaultUT2004WorldView(IMediator messageSource, AgentLogger agentLogger) {
        super(messageSource, agentLogger);
    }

    @Override
    protected boolean isBatchEndEvent(IWorldChangeEvent evt) {
        return evt instanceof EndMessage;
    }

    @Override
    protected boolean isMutable(IViewable obj) {
    	// NavPoint because of lifts...
    	return obj instanceof Player || obj instanceof NavPoint;
    }

    @Override
    protected void setDisappearedFlag(IWorldObject obj) {
        IGBViewable gbView = (IGBViewable) obj;
        IGBWorldObjectDisappeared dis = gbView.createDisappearEvent();        
        dis.update(obj);
    }
}
