package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.agent.worldview.WorldEventListener;
import cz.cuni.amis.pogamut.ut2004.agent.module.AgentModule;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Pong;

import java.util.logging.Logger;

/**
 * Memory module specialized on requests to the map.
 *
 * @author Juraj 'Loque' Simlovic
 */
public class Requests extends AgentModule
{
	/*========================================================================*/

	/**
	 * Pong listener.
	 */
	private class PongListener implements WorldEventListener<Pong>
	{
		@Override
		public void notify(Pong event)
		{
			// FIXME[js]: what to do?
		}

		/**
		 * Constructor. Registers itself on the given WorldView object.
		 * @param worldView WorldView object to listent to.
		 */
		public PongListener(IWorldView worldView)
		{
			worldView.addListener(Pong.class, this);
		}
	}

	/** Pong listener */
	PongListener pongListener;

	/*========================================================================*/

	/**
	 * Constructor. Setups the memory module based on given WorldView.
	 * @param worldView WorldView object to read the info from.
	 * @param log Logger to be used for logging runtime/debug info.
	 */
	public Requests(IWorldView worldView, Logger log)
	{
		super(log);

		// create listeners
		pongListener = new PongListener(worldView);
	}
}
