package cz.cuni.amis.pogamut.ut2004.examples;

import cz.cuni.amis.pogamut.base.communication.connection.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentFactory;
import cz.cuni.amis.pogamut.base.factory.guice.PogamutAgentModule;
import cz.cuni.amis.pogamut.ut2004.bot.AbstractUT2004Bot;

import java.util.logging.Level;

/**
 * Runner for the Simple bot example.
 * @author Knight
 */
public class SimpleBotRunner {

    public PogamutAgentModule module = new SimpleBotModule();

    public void RunSimpleBotAtLocalhost() {

        IAgentFactory<ISocketConnectionAddress> factory = new GuiceAgentFactory(module);

        AbstractUT2004Bot tempAgent = null;

        try {
            tempAgent = (AbstractUT2004Bot) factory.newAgent(new SocketConnectionAddress("localhost", 3000));
        } catch (Exception e) {

            e.printStackTrace();
        }
        final AbstractUT2004Bot agent = tempAgent;

        agent.getLogger().addConsoleHandlersToAllCategories();
        agent.getLogger().setLevel(Level.ALL);

        try {
            agent.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String args[]) {

        SimpleBotRunner botRun = new SimpleBotRunner();
        botRun.RunSimpleBotAtLocalhost();

    }
}
