/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.base.agent;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.AgentStateType;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;

/**
 * Changes states when proper methods are invoked.
 * @author Ik
 */
public class TestingEmptyAgent extends AbstractAgent {

    @JProp
    protected String testProperty = "Test data";
    
    public TestingEmptyAgent() {
        super(new AgentLogger());
        setAgentState(AgentStateType.INSTANTIATED, "");
    }
    
    @Override
    public void start() throws AgentException {
        setAgentState(AgentStateType.RUNNING, "");
    }

    @Override
    public void pause() throws AgentException {
        setAgentState(AgentStateType.PAUSED, "");
    }

    @Override
    public void resume() throws AgentException {
        setAgentState(AgentStateType.RUNNING, "");
        throw new AgentException("Testing exception, should be thrown.", this);
    }

    @Override
    public void stop() {
        setAgentState(AgentStateType.END, "");
    }

    @Override
    public void kill() {
        setAgentState(AgentStateType.FAILED, "");
    }

    @Override
    public String getName() {
        return "Duck";
    }
    
    

}
