package cz.cuni.amis.utils.future;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * Future implementation that holds fixed result.
 */
public class FixedFuture<Result> implements Future<Result> {
	
	private Result result;
	
	public FixedFuture(Result result) {
		this.result = result;
	}
	
	@Override
	public boolean cancel(boolean mayInterruptIfRunning) {
		return false;
	}

	@Override
	public Result get() throws InterruptedException, ExecutionException {
		return result;
	}

	@Override
	public Result get(long timeout, TimeUnit unit)
			throws InterruptedException, ExecutionException,
			TimeoutException {
		return result;
	}

	@Override
	public boolean isCancelled() {
		return false;
	}

	@Override
	public boolean isDone() {
		return true;
	}	

}
