/*
 * ImmutableFlag.java
 *
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.flag.Flag.DoInSync;

/**
 * Flag whose value cannot be set.
 * @author ik
 */
public class ImmutableFlag<T> extends Flag<T> {
    
    protected Flag<T> flag = null;
    
    /** Creates a new instance of ImmutableFlag */
    public ImmutableFlag(Flag<T> flag) {
        this.flag = flag;
    }

    @Override
    public void addListener(FlagListener<T> listener) {
        flag.addListener(listener);
    }
    
    @Override
    public void addStrongListener(FlagListener<T> listener) {
    	flag.addStrongListener(listener);
    }
        
    @Override
    public void clearListeners() {
        flag.clearListeners();
    }
    
    @Override
    public T getFlag(){
        return flag.getFlag();
    }
    
    @Override
    public boolean isListenning(FlagListener<T> listener){
        return flag.isListenning(listener);
    }
        
    @Override
    public void removeListener(FlagListener<T> listener){
        flag.removeListener(listener);
    }

    @Override
    public void setFlag(T newValue) {
        throw new UnsupportedOperationException("Trying to set value of immutable flag.");
    }
    
    @Override
    public ImmutableFlag<T> getImmutable() {
        return this;
    }
    
    @Override
    public void inSync(DoInSync<T> command) {
    	flag.inSyncInner(command, false);
    }
    
    @Override
    public boolean isFrozen() {
    	return flag.isFrozen();
    }
    
    @Override
    public void freeze() {
    	throw new UnsupportedOperationException("Trying to freeze immutable flag.");
    }
    
    @Override
    public void defreeze() {
    	throw new UnsupportedOperationException("Trying to defreeze immutable flag.");
    }
    
}
