package cz.cuni.amis.utils.flag;

public class FlagInteger extends Flag<Integer> {
	
	public FlagInteger(Integer initial) {
		super(initial);
	}
	
	public void increment(final int number) {
		inSync(
			new DoInSync<Integer>() {
	
				@Override
				public void execute(Integer flagValue) {
					setFlag(flagValue+number);
				}
				
			}
		);
	}
	
	public void decrement(final int number) {
		inSync(
			new DoInSync<Integer>() {
	
				@Override
				public void execute(Integer flagValue) {
					setFlag(flagValue-number);
				}
				
			}
		);
	}

}